% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotNorm}
\alias{plotNorm}
\title{Plot manifest and fitted norm scores}
\usage{
plotNorm(
  model,
  age = NULL,
  score = NULL,
  width = NULL,
  weights = NULL,
  group = FALSE,
  minNorm = NULL,
  maxNorm = NULL,
  type = 0
)
}
\arguments{
\item{model}{The regression model, usually from the 'cnorm' or 'cnorm.betabinomial' function}

\item{age}{In case of beta binomial model, please provide the age vector}

\item{score}{In case of beta binomial model, please provide the score vector}

\item{width}{In case of beta binomial model, please provide the width for the sliding window.
If null, the function tries to determine a sensible setting.}

\item{weights}{Vector or variable name in the dataset with weights for each
individual case. If NULL, no weights are used.}

\item{group}{On optional grouping variable, use empty string for no group, the variable name
for Taylor polynomial models or a vector with the groups for beta binomial models}

\item{minNorm}{lower bound of fitted norm scores}

\item{maxNorm}{upper bound of fitted norm scores}

\item{type}{Type of display: 0 = plot manifest against fitted values, 1 = plot
manifest against difference values}
}
\value{
A ggplot object representing the norm scores plot.
}
\description{
This function plots the manifest norm score against the fitted norm score from
the inverse regression model per group. This helps to inspect the precision
of the modeling process. The scores should not deviate too far from
the regression line. Applicable for Taylor polynomial models.
}
\examples{
# Load example data set, compute model and plot results

# Taylor polynomial model
model <- cnorm(raw = elfe$raw, group = elfe$group)
plot(model, "norm")

# Beta binomial models; maximum number of items in elfe is n = 28
model.bb <- cnorm.betabinomial(elfe$group, elfe$raw, n = 28)
plotNorm(model.bb, age = elfe$group, score = elfe$raw)


}
\seealso{
Other plot: 
\code{\link{plot.cnorm}()},
\code{\link{plot.cnormBetaBinomial}()},
\code{\link{plot.cnormBetaBinomial2}()},
\code{\link{plotDensity}()},
\code{\link{plotDerivative}()},
\code{\link{plotNormCurves}()},
\code{\link{plotPercentileSeries}()},
\code{\link{plotPercentiles}()},
\code{\link{plotRaw}()},
\code{\link{plotSubset}()}
}
\concept{plot}
