% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotNorm}
\alias{plotNorm}
\title{Plot manifest and fitted norm scores}
\usage{
plotNorm(data, model, group = "", minNorm = NULL, maxNorm = NULL, type = 0)
}
\arguments{
\item{data}{The raw data within a data.frame or a cnorm object}

\item{model}{The regression model (optional)}

\item{group}{The grouping variable, use empty string for no group}

\item{minNorm}{lower bound of fitted norm scores}

\item{maxNorm}{upper bound of fitted norm scores}

\item{type}{Type of display: 0 = plot manifest against fitted values, 1 = plot
manifest against difference values}
}
\description{
The function plots the manifest norm score against the fitted norm score from
the inverse regression model per group. This helps to inspect the precision
of the modeling process. The scores should not deviate too far from
regression line. The computation of the standard error is based on Oosterhuis, van der
Ark and Sijtsma (2016).
}
\examples{
# Load example data set, compute model and plot results
\dontrun{
result <- cnorm(raw = elfe$raw, group = elfe$group)
plotNorm(result, group="group", minNorm=25, maxNorm=75)
}
}
\references{
Oosterhuis, H. E. M., van der Ark, L. A., & Sijtsma, K. (2016). Sample Size Requirements for Traditional and Regression-Based Norms. Assessment, 23(2), 191–202. https://doi.org/10.1177/1073191115580638
}
\seealso{
Other plot: 
\code{\link{plot.cnorm}()},
\code{\link{plotDensity}()},
\code{\link{plotDerivative}()},
\code{\link{plotNormCurves}()},
\code{\link{plotPercentileSeries}()},
\code{\link{plotPercentiles}()},
\code{\link{plotRaw}()},
\code{\link{plotSubset}()}
}
\concept{plot}
