% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{rawTable}
\alias{rawTable}
\title{Create a table with norm scores assigned to raw scores for a specific age based on the regression model}
\usage{
rawTable(
  A,
  model,
  minRaw = NULL,
  maxRaw = NULL,
  minNorm = NULL,
  maxNorm = NULL,
  step = 1,
  covariate = NULL,
  monotonuous = TRUE
)
}
\arguments{
\item{A}{the age, either single value or vector with age values}

\item{model}{The regression model}

\item{minRaw}{The lower bound of the raw score range}

\item{maxRaw}{The upper bound of the raw score range}

\item{minNorm}{Clipping parameter for the lower bound of norm scores (default 25)}

\item{maxNorm}{Clipping parameter for the upper bound of norm scores (default 25)}

\item{step}{Stepping parameter for the raw scores (default 1)}

\item{covariate}{In case, a covariate has been used, please specify the degree of the covariate /
the specific value here.}

\item{monotonuous}{corrects for decreasing norm scores in case of model inconsistencies (default)}
}
\value{
either data.frame with raw scores and the predicted norm scores in case of simple A value or a list
of norm tables if vector of A values was provided
}
\description{
This function is comparable to 'normTable', despite it reverses the assignment:
A table with raw scores and the according norm scores for a specific age based on the regression
model is generated. This way, the inverse function of the regression model is solved numerically with
brute force. Please specify the range of raw values, you want to cover. With higher precision
and smaller stepping, this function becomes computational intensive.
}
\examples{
normData <- prepareData()
m <- bestModel(data = normData)
# generate a norm table for the raw value range from 0 to 28 for month 7 of grade 3
table <- rawTable(3 + 7 / 12, m, minRaw = 0, maxRaw = 28)

# generate several raw tables
table <- rawTable(c(2.5, 3.5, 4.5), m, minRaw = 0, maxRaw = 28)
}
\seealso{
normTable
}
