% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppvt}
\alias{ppvt}
\title{Vocabulary development from 4 to 16}
\format{A data frame with 5600 rows and 4 variables:
\describe{
  \item{age}{the chronological age of the child}
  \item{group}{the according age group, e.g. age group 4 consists of children age 3.5 to 4.5}
  \item{sex}{the sex of the test taker, 1=male, 2=female}
  \item{raw}{the raw score of the student, spanning values from 0 to 228}
}}
\source{
\url{https://www.psychometrica.de/ppvt4.html}
}
\usage{
ppvt
}
\description{
A dataset based on an unstratified sample of PPVT4 data (German adaption). The PPVT4 consists of blocks of items with
12 items each. Each item consists of 4 pictures. The test taker is given a word orally and he or she has to point out
the picture matching the oral word. Bottom and ceiling blocks of items are determined according to age and performance. For
instance, when a student knows less than 4 word from a block of 12 items, the testing stops. The sample is not identical
with the norm sample and includes doublets of cases in order to align the sample size per age group. It is
primarily intended for running the cNORM analyses. The cleaned and stratified data is available on request.
}
\examples{
\dontrun{
# Example with continuous age variable
data.ppvt <- rankBySlidingWindow(ppvt, age="age", width=1.5)
data.ppvt <- computePowers(data.ppvt, age="age")
model.ppvt <- bestModel(data.ppvt, R2 = .994)

# plot information function
plotSubset(model.ppvt, type=2)

# check model consistency
checkConsistency(model.ppvt)

# plot percentiles
plotPercentiles(data.ppvt, model.ppvt)
}
}
\references{
Lenhard, A., Lenhard, W., Segerer, R. & Suggate, S. (2015). Peabody Picture Vocabulary Test - Revision IV (Deutsche Adaption). Frankfurt a. M./Germany: Pearson Assessment.
}
\keyword{datasets}
