% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fevd.R, R/plot.bvarfevd.R
\name{fevd}
\alias{fevd}
\alias{plot.bvarfevd}
\title{Forecast Error Variance Decomposition
 
A generic function used to calculate forecast error varianc decompositions.}
\usage{
fevd(object, ...)

\method{plot}{bvarfevd}(x, ...)
}
\arguments{
\item{object}{an object of class \code{"bvar"}.}

\item{...}{further graphical parameters.}

\item{x}{an object of class "bvarfevd", usually, a result of a call to \code{\link{fevd}}.}
}
\description{
A plot function for objects of class "bvarfevd".
}
\examples{

# Load data
data("e1")
e1 <- diff(log(e1)) * 100

# Generate model data
model <- gen_var(e1, p = 2, deterministic = 2,
                 iterations = 100, burnin = 10)
# Chosen number of iterations and burnin should be much higher.

# Add prior specifications
model <- add_priors(model)

# Obtain posterior draws
object <- draw_posterior(model)

# Obtain FEVD
vd <- fevd(object, response = "cons")

# Plot
plot(vd)

}
