% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_resource_inconsistencies.R
\name{fix_resource_inconsistencies}
\alias{fix_resource_inconsistencies}
\alias{fix_resource_inconsistencies.activitylog}
\alias{fix_resource_inconsistencies.eventlog}
\title{Fix resource inconsistencies}
\usage{
fix_resource_inconsistencies(eventlog, filter_condition,
  overwrite_missings, detected_problems, details)

\method{fix_resource_inconsistencies}{activitylog}(eventlog,
  filter_condition = NULL, overwrite_missings = FALSE,
  detected_problems = NULL, details = TRUE)

\method{fix_resource_inconsistencies}{eventlog}(eventlog,
  filter_condition = NULL, overwrite_missings = FALSE,
  detected_problems = NULL, details = TRUE)
}
\arguments{
\item{eventlog}{Event log object}

\item{filter_condition}{Condition that is used to extract a subset of the activity log prior to the application of the function}

\item{overwrite_missings}{If events are missing, overwrite the resource if other events within activity instance are performed by single resource. Default FALSE.}

\item{detected_problems}{If available, the problems detected that need to be fixed. If not available, the function detect_resource_inconsistenties will be called.}

\item{details}{Show details}
}
\description{
Fix resource inconsistencies
}
\section{Methods (by class)}{
\itemize{
\item \code{activitylog}: activitylog Fix activitylog

\item \code{eventlog}: eventlog Fix eventlog
}}

