% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_interpol.R
\name{interpol_un_notice}
\alias{interpol_un_notice}
\title{Get an Interpol UN notice}
\usage{
interpol_un_notice(
  notice_type,
  notice_id,
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{notice_type}{Notice type: "persons" or "entities".}

\item{notice_id}{Notice ID.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with notice details.
}
\description{
Get an Interpol UN notice
}
\details{
Returns detailed data for a UN notice.
Official docs: https://interpol.api.bund.dev.
}
\examples{
\dontrun{
interpol_un_notice("persons", "2021-84506")
}

}
