% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildbam}
\alias{buildbam}
\title{Use \code{buildmer} to fit big generalized additive models using \code{bam} from package \code{mgcv}}
\usage{
buildbam(
  formula,
  data = NULL,
  family = gaussian(),
  cl = NULL,
  direction = c("order", "backward"),
  crit = "deviance",
  include = NULL,
  calc.anova = FALSE,
  calc.summary = TRUE,
  ...
)
}
\arguments{
\item{formula}{See the general documentation under \code{\link{buildmer-package}}}

\item{data}{See the general documentation under \code{\link{buildmer-package}}}

\item{family}{See the general documentation under \code{\link{buildmer-package}}}

\item{cl}{See the general documentation under \code{\link{buildmer-package}}}

\item{direction}{See the general documentation under \code{\link{buildmer-package}}}

\item{crit}{See the general documentation under \code{\link{buildmer-package}}}

\item{include}{See the general documentation under \code{\link{buildmer-package}}}

\item{calc.anova}{See the general documentation under \code{\link{buildmer-package}}}

\item{calc.summary}{See the general documentation under \code{\link{buildmer-package}}}

\item{...}{Additional options to be passed to \code{bam}}
}
\description{
Use \code{buildmer} to fit big generalized additive models using \code{bam} from package \code{mgcv}
}
\details{
To work around an issue in \code{bam()}, you must make sure that your data do not contain a variable named 'intercept'.

\code{lme4} random effects are supported: they will be automatically converted using \code{\link{re2mgcv}}.

As \code{bam} uses PQL, only \code{crit='deviance'} is supported.
}
\examples{
\dontshow{
library(buildmer)
model <- buildbam(f1 ~ s(timepoint,bs='cr'),data=vowels)
}
\donttest{
library(buildmer)
model <- buildbam(f1 ~ s(timepoint,by=following) + s(participant,by=following,bs='re') +
       s(participant,timepoint,by=following,bs='fs'),data=vowels)
}
}
\seealso{
\code{\link{buildmer-package}}
}
