% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_mcmc.R
\name{run_mcmc.ngssm}
\alias{run_mcmc.ngssm}
\alias{run_mcmc.ng_bsm}
\alias{run_mcmc.ng_ar1}
\alias{run_mcmc.svm}
\alias{run_mcmc.nlg_ssm}
\alias{run_mcmc.sde_ssm}
\title{Bayesian inference of non-Gaussian or non-linear state space models using MCMC}
\usage{
\method{run_mcmc}{ngssm}(object, n_iter, nsim_states, type = "full",
  method = "da", simulation_method = "psi", n_burnin = floor(n_iter/2),
  n_thin = 1, gamma = 2/3, target_acceptance = 0.234, S,
  end_adaptive_phase = TRUE, local_approx = TRUE, n_threads = 1,
  seed = sample(.Machine$integer.max, size = 1), max_iter = 100,
  conv_tol = 1e-08, ...)

\method{run_mcmc}{ng_bsm}(object, n_iter, nsim_states, type = "full",
  method = "da", simulation_method = "psi", n_burnin = floor(n_iter/2),
  n_thin = 1, gamma = 2/3, target_acceptance = 0.234, S,
  end_adaptive_phase = TRUE, local_approx = TRUE, n_threads = 1,
  seed = sample(.Machine$integer.max, size = 1), max_iter = 100,
  conv_tol = 1e-08, ...)

\method{run_mcmc}{ng_ar1}(object, n_iter, nsim_states, type = "full",
  method = "da", simulation_method = "psi", n_burnin = floor(n_iter/2),
  n_thin = 1, gamma = 2/3, target_acceptance = 0.234, S,
  end_adaptive_phase = TRUE, local_approx = TRUE, n_threads = 1,
  seed = sample(.Machine$integer.max, size = 1), max_iter = 100,
  conv_tol = 1e-08, ...)

\method{run_mcmc}{svm}(object, n_iter, nsim_states, type = "full",
  method = "da", simulation_method = "psi", n_burnin = floor(n_iter/2),
  n_thin = 1, gamma = 2/3, target_acceptance = 0.234, S,
  end_adaptive_phase = TRUE, local_approx = TRUE, n_threads = 1,
  seed = sample(.Machine$integer.max, size = 1), max_iter = 100,
  conv_tol = 1e-08, ...)

\method{run_mcmc}{nlg_ssm}(object, n_iter, nsim_states, type = "full",
  method = "da", simulation_method = "psi", n_burnin = floor(n_iter/2),
  n_thin = 1, gamma = 2/3, target_acceptance = 0.234, S,
  end_adaptive_phase = TRUE, n_threads = 1,
  seed = sample(.Machine$integer.max, size = 1), max_iter = 100,
  conv_tol = 1e-04, iekf_iter = 0, ...)

\method{run_mcmc}{sde_ssm}(object, n_iter, nsim_states, type = "full",
  method = "da", L_c, L_f, n_burnin = floor(n_iter/2), n_thin = 1,
  gamma = 2/3, target_acceptance = 0.234, S, end_adaptive_phase = TRUE,
  n_threads = 1, seed = sample(.Machine$integer.max, size = 1), ...)
}
\arguments{
\item{object}{Model object.}

\item{n_iter}{Number of MCMC iterations.}

\item{nsim_states}{Number of state samples per MCMC iteration.
If <2, approximate inference based on Gaussian approximation is performed.}

\item{type}{Either \code{"full"} (default), or \code{"summary"}. The
former produces samples of states whereas the latter gives the mean and
variance estimates of the states.}

\item{method}{What MCMC algorithm to use? Possible choices are
\code{"pm"} for pseudo-marginal MCMC,
\code{"da"} for delayed acceptance version of PMCMC (default), or one of the three
importance sampling type weighting schemes:
\code{"is3"} for simple importance sampling (weight is computed for each MCMC iteration independently),
\code{"is2"} for jump chain importance sampling type weighting, or
\code{"is1"} for importance sampling type weighting where the number of particles used for
weight computations is proportional to the length of the jump chain block.}

\item{simulation_method}{If \code{"spdk"}, non-sequential importance sampling based
on Gaussian approximation is used. If \code{"bsf"}, bootstrap filter
is used (default for \code{"nlg_ssm"} and only option for \code{"sde_ssm"}),
and if \code{"psi"}, psi-auxiliary particle filter is used
(default for models with linear-Gaussian state equation).}

\item{n_burnin}{Length of the burn-in period which is disregarded from the
results. Defaults to \code{n_iter / 2}.}

\item{n_thin}{Thinning rate. Defaults to 1. Increase for large models in
order to save memory. For IS-corrected methods, larger
value can also be statistically more effective. 
Note: With \code{type = "summary"}, the thinning does not affect the computations 
of the summary statistics in case of pseudo-marginal methods.}

\item{gamma}{Tuning parameter for the adaptation of RAM algorithm. Must be
between 0 and 1 (not checked).}

\item{target_acceptance}{Target acceptance ratio for RAM. Defaults to 0.234.}

\item{S}{Initial value for the lower triangular matrix of RAM
algorithm, so that the covariance matrix of the Gaussian proposal
distribution is \eqn{SS'}. Note that for some parameters 
(currently the standard deviation and dispersion parameters of bsm models) the sampling
is done for transformed parameters with internal_theta = log(1 + theta).}

\item{end_adaptive_phase}{If \code{TRUE} (default), $S$ is held fixed after the burnin period.}

\item{local_approx}{If \code{TRUE} (default), Gaussian approximation needed for
importance sampling is performed at each iteration. If false, approximation is updated only
once at the start of the MCMC. Not used for non-linear models.}

\item{n_threads}{Number of threads for state simulation.}

\item{seed}{Seed for the random number generator.}

\item{max_iter}{Maximum number of iterations used in Gaussian approximation. Used psi-PF.}

\item{conv_tol}{Tolerance parameter used in Gaussian approximation. Used psi-PF.}

\item{...}{Ignored.}

\item{iekf_iter}{If zero (default), first approximation for non-linear
Gaussian models is obtained from extended Kalman filter. If
\code{iekf_iter > 0}, iterated extended Kalman filter is used with
\code{iekf_iter} iterations.}

\item{L_c, L_f}{Integer values defining the discretization levels for first and second stages. 
For PM methods, maximum of these is used.}
}
\description{
Methods for posterior inference of states and parameters.
}
\examples{
set.seed(1)
n <- 50 
slope <- cumsum(c(0, rnorm(n - 1, sd = 0.001)))
level <- cumsum(slope + c(0, rnorm(n - 1, sd = 0.2)))
y <- rpois(n, exp(level))
poisson_model <- ng_bsm(y, 
  sd_level = halfnormal(0.01, 1), 
  sd_slope = halfnormal(0.01, 0.1), 
  P1 = diag(c(10, 0.1)), distribution = "poisson")
mcmc_is <- run_mcmc(poisson_model, n_iter = 1000, nsim_states = 10, method = "is2")
summary(mcmc_is, only_theta = TRUE, return_se = TRUE)
}
