% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_easystats.R
\name{tidy_parameters}
\alias{tidy_parameters}
\title{tidy_parameters}
\usage{
tidy_parameters(x, conf.int = TRUE, ...)
}
\arguments{
\item{x}{An object to be converted into a tidy \code{\link[tibble:tibble]{tibble::tibble()}}.}

\item{conf.int}{Indicating whether or not to include a confidence interval in
the tidied output.}

\item{...}{Additional arguments to tidying method.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Computes parameters for regression models.
}
\details{
The function will attempt to get these details either using
\code{broom::tidy} or \code{parameters::model_parameters}.
}
\examples{
set.seed(123)
mod <- lm(mpg ~ wt + cyl, data = mtcars)
tidy_parameters(mod)
}
