% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orcutt-tidiers.R
\name{tidy.orcutt}
\alias{tidy.orcutt}
\alias{orcutt_tidiers}
\title{Tidy a(n) orcutt object}
\usage{
\method{tidy}{orcutt}(x, ...)
}
\arguments{
\item{x}{An \code{orcutt} object returned from \code{\link[orcutt:cochrane.orcutt]{orcutt::cochrane.orcutt()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{
\dontshow{if (rlang::is_installed("orcutt")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# load libraries for models and data
library(orcutt)

# fit model and summarize results
reg <- lm(mpg ~ wt + qsec + disp, mtcars)
tidy(reg)


co <- cochrane.orcutt(reg)
tidy(co)
glance(co)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[orcutt:cochrane.orcutt]{orcutt::cochrane.orcutt()}}

Other orcutt tidiers: 
\code{\link{glance.orcutt}()}
}
\concept{orcutt tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{estimate}{The estimated value of the regression term.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{std.error}{The standard error of the regression term.}
  \item{term}{The name of the regression term.}

}
