% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-tidiers.R
\name{glance.ergm}
\alias{glance.ergm}
\title{Glance at a(n) ergm object}
\usage{
\method{glance}{ergm}(x, deviance = FALSE, mcmc = FALSE, ...)
}
\arguments{
\item{x}{An \code{ergm} object returned from a call to \code{\link[ergm:ergm]{ergm::ergm()}}.}

\item{deviance}{Logical indicating whether or not to report null and
residual deviance for the model, as well as degrees of freedom. Defaults
to \code{FALSE}.}

\item{mcmc}{Logical indicating whether or not to report MCMC interval,
burn-in and sample size used to estimate the model. Defaults to \code{FALSE}.}

\item{...}{Additional arguments to pass to \code{\link[ergm:summary]{ergm::summary()}}.
\strong{Cautionary note}: Mispecified arguments may be silently ignored.}
}
\value{
\code{glance.ergm} returns a one-row data.frame with the columns
\item{independence}{Whether the model assumed dyadic independence}
\item{iterations}{The number of MCMLE iterations performed before convergence}
\item{logLik}{If applicable, the log-likelihood associated with the model}
\item{AIC}{The Akaike Information Criterion}
\item{BIC}{The Bayesian Information Criterion}

If \code{deviance = TRUE}, and if the model supports it, the
data frame will also contain the columns
\item{null.deviance}{The null deviance of the model}
\item{df.null}{The degrees of freedom of the null deviance}
\item{residual.deviance}{The residual deviance of the model}
\item{df.residual}{The degrees of freedom of the residual deviance}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modelling
function. This includes the name of the modelling function or any
arguments passed to the modelling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.
}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[ergm:ergm]{ergm::ergm()}}, \code{\link[ergm:summary.ergm]{ergm::summary.ergm()}}

Other ergm tidiers: \code{\link{tidy.ergm}}
}
\concept{ergm tidiers}
