% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btergm_tidiers.R
\name{btergm_tidiers}
\alias{btergm_tidiers}
\alias{tidy.btergm}
\title{Tidying method for a bootstrapped temporal exponential random graph model}
\usage{
\method{tidy}{btergm}(x, conf.level = 0.95, exponentiate = FALSE,
  quick = FALSE, ...)
}
\arguments{
\item{x}{a \code{\link[btergm]{btergm}} object}

\item{conf.level}{confidence level of the bootstrapped interval}

\item{exponentiate}{whether to exponentiate the coefficient estimates
and confidence intervals}

\item{quick}{whether to compute a smaller and faster version, containing
only the \code{term} and \code{estimate} columns.}

\item{...}{extra arguments (currently not used)}
}
\value{
A \code{data.frame} without rownames.

\code{tidy.btergm} returns one row for each coefficient, 
with four columns:
  \item{term}{The term in the model being estimated and tested}
  \item{estimate}{The estimated coefficient}
  \item{conf.low}{The lower bound of the confidence interval}
  \item{conf.high}{The lower bound of the confidence interval}
}
\description{
This method tidies the coefficients of a bootstrapped temporal exponential 
random graph model estimated with the \pkg{xergm}. It simply returns the
coefficients and their confidence intervals.
}
\details{
There is no \code{augment} or \code{glance} method 
for \pkg{ergm} objects.
}
\examples{

if (require("xergm")) {
    # Using the same simulated example as the xergm package
    # Create 10 random networks with 10 actors
    networks <- list()
    for(i in 1:10){
        mat <- matrix(rbinom(100, 1, .25), nrow = 10, ncol = 10)
        diag(mat) <- 0
        nw <- network::network(mat)
        networks[[i]] <- nw
    }
    # Create 10 matrices as covariates
    covariates <- list()
    for (i in 1:10) {
        mat <- matrix(rnorm(100), nrow = 10, ncol = 10)
        covariates[[i]] <- mat
    }
    # Fit a model where the propensity to form ties depends
    # on the edge covariates, controlling for the number of
    # in-stars
    btfit <- btergm(networks ~ edges + istar(2) +
                      edgecov(covariates), R = 100)

    # Show terms, coefficient estimates and errors
    tidy(btfit)

    # Show coefficients as odds ratios with a 99\% CI
    tidy(btfit, exponentiate = TRUE, conf.level = 0.99)
}
}
\seealso{
\code{\link[btergm]{btergm}}
}

