% Generated by roxygen2 (4.0.2): do not edit by hand
\name{aareg_tidiers}
\alias{aareg_tidiers}
\alias{glance.aareg}
\alias{tidy.aareg}
\title{Tidiers for aareg objects}
\usage{
\method{tidy}{aareg}(x, ...)

\method{glance}{aareg}(x, ...)
}
\arguments{
\item{x}{an "aareg" object}

\item{...}{extra arguments (not used)}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy.aareg} returns one row for each coefficient, with
the columns
  \item{term}{name of coefficient}
  \item{estimate}{estimate of the slope}
  \item{statistic}{test statistic for coefficient}
  \item{std.error}{standard error of statistic}
  \item{robust.se}{robust version of standard error estimate}
  \item{z}{z score}
  \item{p.value}{p-value}

\code{glance} returns a one-row data frame containing
  \item{statistic}{chi-squared statistic}
  \item{p.value}{p-value based on chi-squared statistic}
  \item{df}{degrees of freedom used by coefficients}
}
\description{
These tidy the coefficients of Aalen additive regression objects.
}
\examples{
if (require("survival", quietly)) {
    afit <- aareg(Surv(time, status) ~ age + sex + ph.ecog, data=lung,
                  dfbeta=TRUE)
    summary(afit)
    tidy(afit)
}
}

