% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_omega}
\alias{get_omega}
\title{Extract Variance and Correlation Components}
\usage{
get_omega(
  x,
  hide = c("right", "left", "boundary", "internal", "none"),
  cor = FALSE,
  whatknots = "all",
  what = "cov"
)
}
\arguments{
\item{x}{Object of class \code{brokenstick}}

\item{hide}{Should output for knots be hidden in get, print, summary and plot
functions? Can be \code{"left"}, \code{"right"}, \code{"boundary"}, \code{"internal"} or \code{"none"}.
The default is \code{"right"}.}

\item{cor}{Logical. Should the function return the correlation matrix
instead of the covariance matrix? The default is \code{FALSE}.}

\item{whatknots}{Deprecated.}

\item{what}{Deprecated.}
}
\value{
A numeric matrix, possibly with zero rows and columns if no names match
}
\description{
Extracts variance-covariance or correlation matrix from a
\code{brokenstick} object.
}
\examples{
f1 <- brokenstick(hgt_z ~ age | id, smocc_200[1:1000, ], knots = 0:2, seed = 1)
get_omega(f1, cor = TRUE, hide = "boundary")
}
