% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_draws.R
\name{extract_draws.brmsfit}
\alias{extract_draws.brmsfit}
\alias{extract_draws}
\title{Extract Data and Posterior Draws}
\usage{
\method{extract_draws}{brmsfit}(x, newdata = NULL, re_formula = NULL,
  allow_new_levels = FALSE, sample_new_levels = "uncertainty",
  incl_autocor = TRUE, oos = NULL, resp = NULL, nsamples = NULL,
  subset = NULL, nug = NULL, smooths_only = FALSE, offset = TRUE,
  new_objects = list(), ...)

extract_draws(x, ...)
}
\arguments{
\item{x}{An \R object typically of class \code{'brmsfit'}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA}, include no group-level effects.}

\item{allow_new_levels}{A flag indicating if new levels of group-level
effects are allowed (defaults to \code{FALSE}). Only relevant if
\code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels for grouping
factors specified in \code{re_formula}. This argument is only relevant if
\code{newdata} is provided and \code{allow_new_levels} is set to
\code{TRUE}. If \code{"uncertainty"} (default), include group-level
uncertainty in the predictions based on the variation of the existing
levels. If \code{"gaussian"}, sample new levels from the (multivariate)
normal distribution implied by the group-level standard deviations and
correlations. This options may be useful for conducting Bayesian power
analysis. If \code{"old_levels"}, directly sample new levels from the
existing levels.}

\item{incl_autocor}{A flag indicating if ARMA autocorrelation parameters
should be included in the predictions. Defaults to \code{TRUE}. Setting it
to \code{FALSE} will not affect other correlation structures such as
\code{\link[brms:cor_bsts]{cor_bsts}}, or
\code{\link[brms:cor_fixed]{cor_fixed}}.}

\item{oos}{Optional indices of observations for which to compute
out-of-sample rather than in-sample predictions. Only required in models
that make use of response values to make predictions, that is currently
only ARMA models.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{nsamples}{Positive integer indicating how many posterior samples should
be used. If \code{NULL} (the default) all samples are used. Ignored if
\code{subset} is not \code{NULL}.}

\item{subset}{A numeric vector specifying the posterior samples to be used.
If \code{NULL} (the default), all samples are used.}

\item{nug}{Small positive number for Gaussian process terms only. For
numerical reasons, the covariance matrix of a Gaussian process might not be
positive definite. Adding a very small number to the matrix's diagonal
often solves this problem. If \code{NULL} (the default), \code{nug} is
chosen internally.}

\item{smooths_only}{Logical; If \code{TRUE} only draws related to the
computation of smooth terms will be extracted.}

\item{offset}{Logical; Indicates if offsets should be included in the
predictions. Defaults to \code{TRUE}.}

\item{new_objects}{A named \code{list} of objects containing new data, which
cannot be passed via argument \code{newdata}. Required for objects passed
via \code{\link{stanvars}} and for \code{\link[brms:cor_sar]{cor_sar}} and
\code{\link[brms:cor_fixed]{cor_fixed}} correlation structures.}

\item{...}{Further arguments passed to \code{\link{validate_newdata}}.}
}
\value{
An object of class \code{'brmsdraws'} or \code{'mvbrmsdraws'},
  depending on whether a univariate or multivariate model is passed.
}
\description{
This method helps in preparing \pkg{brms} models for certin post-processing
tasks most notably various forms of predictions. Unless you are a package
developer, you will rarely need to call \code{extract_draws} directly.
}
