% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{waic.brmsfit}
\alias{waic.brmsfit}
\alias{waic}
\alias{WAIC}
\alias{WAIC.brmsfit}
\title{Compute the WAIC}
\usage{
\method{waic}{brmsfit}(x, ..., compare = TRUE, resp = NULL,
  pointwise = FALSE, model_names = NULL)
}
\arguments{
\item{x}{A fitted model object.}

\item{...}{More fitted model objects or further arguments
passed to the underlying post-processing functions.}

\item{compare}{A flag indicating if the information criteria
of the models should be compared to each other
via \code{\link{compare_ic}}.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{pointwise}{A flag indicating whether to compute the full
log-likelihood matrix at once or separately for each observation. 
The latter approach is usually considerably slower but 
requires much less working memory. Accordingly, if one runs 
into memory issues, \code{pointwise = TRUE} is the way to go.}

\item{model_names}{If \code{NULL} (the default) will use model names 
derived from deparsing the call. Otherwise will use the passed 
values as model names.}
}
\value{
If just one object is provided, an object of class \code{ic}. 
 If multiple objects are provided, an object of class \code{iclist}.
}
\description{
Compute the widely applicable information criterion (WAIC)
based on the posterior likelihood using the \pkg{loo} package.
For more details see \code{\link[loo:waic]{waic}}
}
\details{
When comparing models fitted to the same data, 
 the smaller the WAIC, the better the fit. For \code{brmsfit} 
 objects, \code{WAIC} is an alias of \code{waic}.
 Use method \code{\link[brms:add_ic]{add_ic}} to store
 information criteria in the fitted model object for later usage.
}
\examples{
\dontrun{
# model with population-level effects only
fit1 <- brm(rating ~ treat + period + carry,
            data = inhaler, family = "gaussian")
waic(fit1)

# model with an additional varying intercept for subjects
fit2 <- brm(rating ~ treat + period + carry + (1|subject),
            data = inhaler, family = "gaussian")
# compare both models
waic(fit1, fit2)                          
}

}
\references{
Vehtari, A., Gelman, A., & Gabry J. (2016). Practical Bayesian model
evaluation using leave-one-out cross-validation and WAIC. In Statistics 
and Computing, doi:10.1007/s11222-016-9696-4. arXiv preprint arXiv:1507.04544.

Gelman, A., Hwang, J., & Vehtari, A. (2014). 
Understanding predictive information criteria for Bayesian models. 
Statistics and Computing, 24, 997-1016.

Watanabe, S. (2010). Asymptotic equivalence of Bayes cross validation 
and widely applicable information criterion in singular learning theory. 
The Journal of Machine Learning Research, 11, 3571-3594.
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
