% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{ZeroInflated}
\alias{ZeroInflated}
\alias{dzero_inflated_poisson}
\alias{pzero_inflated_poisson}
\alias{dzero_inflated_negbinomial}
\alias{pzero_inflated_negbinomial}
\alias{dzero_inflated_binomial}
\alias{pzero_inflated_binomial}
\alias{dzero_inflated_beta}
\alias{pzero_inflated_beta}
\title{Zero-Inflated Distributions}
\usage{
dzero_inflated_poisson(x, lambda, zi, log = FALSE)

pzero_inflated_poisson(q, lambda, zi, lower.tail = TRUE, log.p = FALSE)

dzero_inflated_negbinomial(x, mu, shape, zi, log = FALSE)

pzero_inflated_negbinomial(q, mu, shape, zi, lower.tail = TRUE,
  log.p = FALSE)

dzero_inflated_binomial(x, size, prob, zi, log = FALSE)

pzero_inflated_binomial(q, size, prob, zi, lower.tail = TRUE, log.p = FALSE)

dzero_inflated_beta(x, shape1, shape2, zi, log = FALSE)

pzero_inflated_beta(q, shape1, shape2, zi, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{x}{Vector of quantiles.}

\item{zi}{zero-inflation propability}

\item{log}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{q}{Vector of quantiles.}

\item{lower.tail}{Logical; If \code{TRUE} (default), return P(X <= x). 
Else, return P(X > x) .}

\item{log.p}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{mu, lambda}{location parameter}

\item{shape, shape1, shape2}{shape parameter}

\item{size}{number of trials}

\item{prob}{probability of success on each trial}
}
\description{
Density and distribution functions for zero-inflated distributions.
}
\details{
The density of a zero-inflated distribution can be specified as follows.
If \eqn{x = 0} set \eqn{f(x) = \theta + (1 - \theta) * g(0)}.
Else set \eqn{f(x) = (1 - \theta) * g(x)},
where \eqn{g(x)} is the density of the non-zero-inflated part.
}
