% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projpred.R
\name{varsel.brmsfit}
\alias{varsel.brmsfit}
\alias{varsel}
\alias{cv_varsel}
\alias{cv_varsel.brmsfit}
\title{Projection Predictive Variable Selection}
\usage{
\method{varsel}{brmsfit}(object, ...)

\method{cv_varsel}{brmsfit}(object, ...)
}
\arguments{
\item{object}{A \code{brmsfit} object.}

\item{...}{Further arguments passed to \code{\link{get_refmodel.brmsfit}}
as well as \code{\link[projpred:varsel]{varsel.refmodel}} or 
\code{\link[projpred:cv_varsel]{cv_varsel.refmodel}}.}
}
\value{
A \code{vsel} object for which several methods are available
in the \pkg{projpred} package.
}
\description{
Perform projection predictive variable selection with the \pkg{projpred}
package. See \code{\link[projpred:varsel]{varsel}} and
\code{\link[projpred:cv_varsel]{cv_varsel}} for more details.
}
\examples{
\dontrun{
# fit a simple model
fit <- brm(count ~ zAge + zBase * Trt,
           data = epilepsy, family = poisson())
summary(fit)

# perform variable selection without cross-validation
vs <- varsel(fit)
summary(vs)
plot(vs)

# perform variable selection with cross-validation
cv_vs <- cv_varsel(fit)
summary(cv_vs)
plot(cv_vs)
}

}
