% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-helpers.R
\name{brmsfit_needs_refit}
\alias{brmsfit_needs_refit}
\title{Check if cached fit can be used.}
\usage{
brmsfit_needs_refit(
  fit,
  sdata = NULL,
  scode = NULL,
  algorithm = NULL,
  silent = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{fit}{Old \code{brmsfit} object (e.g., loaded from file).}

\item{sdata}{New Stan data (result of a call to \code{\link{make_standata}}).
Pass \code{NULL} to avoid data check.}

\item{scode}{New Stan code (result of a call to \code{\link{make_stancode}}).
Pass \code{NULL} to avoid code check.}

\item{algorithm}{New algorithm. Pass \code{NULL} to avoid algorithm check.}

\item{silent}{Logical. If \code{TRUE}, no messages will be given.}

\item{verbose}{Logical. If \code{TRUE} detailed report of the differences 
is printed to the console.}
}
\value{
A boolean indicating whether a refit is needed.
}
\description{
Checks whether a given cached fit can be used without refitting when 
\code{file_refit = "on_change"} is used.
This function is internal and exposed only to facilitate debugging problems 
with cached fits. The function may change or be removed in future versions
and scripts should not use it.
}
\details{
Use with \code{verbose = TRUE} to get additional info on how the stored
fit differs from the given data and code.
}
\keyword{internal}
