% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{coef.brmsfit}
\alias{coef.brmsfit}
\title{Extract model coefficients}
\usage{
\method{coef}{brmsfit}(object, estimate = c("mean", "median"), ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}}

\item{estimate}{The point estimate to be calculated 
for the random effects, either "mean" or "median".}

\item{...}{Further arguments to be passed to the function 
specified in \code{estimate}}
}
\value{
A list of matrices (one per grouping factor and 
 non-linear parameter) with factor levels as row names and 
 coefficients as column names.
}
\description{
Extract model coefficients, which are the sum of population-level 
effects and corresponding group-level effects
}
\examples{
\dontrun{
fit <- brm(count ~ log_Age_c + log_Base4_c * Trt_c + (1+Trt_c|visit), 
           data = epilepsy, family = "poisson", chains = 1)
## extract population and group-level coefficients separately
fixef(fit)
ranef(fit)
## extract combined coefficients 
coef(fit)
}

}

