% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brif.R
\name{brif}
\alias{brif}
\title{Build a model (and make predictions)}
\usage{
brif(x, ...)
}
\arguments{
\item{x}{a data frame or a \code{\link[stats]{formula}} object.}

\item{...}{arguments passed on to \code{\link{brif.formula}}, \code{\link{brif.default}} or \code{\link{brif.trainpredict}}.}
}
\value{
a data frame, a vector or a list. If \code{newdata} is supplied,  prediction results for \code{newdata} will be returned in a data frame or a vector, depending on the problem type (classification or regression) and the \code{type} argument; otherwise, an object of class "brif" is returned, which is to be used in the function \code{\link[brif]{predict.brif}} for making predictions. See \code{\link[brif]{brif.default}} for components of the "brif" object.
}
\description{
Depending on the arguments supplied, the function \code{\link[brif]{brif.formula}},  \code{\link[brif]{brif.default}} or \code{\link[brif]{brif.trainpredict}} will be called.
}
\examples{
trainset <- sample(1:nrow(iris), 0.5*nrow(iris))
validset <- setdiff(1:nrow(iris), trainset)

# Train and predict at once 
pred_scores <- brif(Species~., data = iris, subset = trainset, 
                    newdata = iris[validset, 1:4], type = 'score')
pred_labels <- brif(Species~., data = iris, subset = trainset, 
                    newdata = iris[validset, 1:4], type = 'class')

# Confusion matrix
table(pred_labels, iris[validset, 5])

# Accuracy
sum(pred_labels == iris[validset, 5])/length(validset)

# Train using the formula format
bf <- brif(Species~., data = iris, subset = trainset)

# Or equivalently, train using the data.frame format
bf <- brif(iris[trainset, c(5,1:4)])

# Make a prediction 
pred_scores <- predict(bf, iris[validset, 1:4], type = 'score')
pred_labels <- predict(bf, iris[validset, 1:4], type = 'class')

# Regression
bf <- brif(mpg ~., data = mtcars)
pred <- predict(bf, mtcars[2:11])
plot(pred, mtcars$mpg)
abline(0, 1)

# Optionally, delete the model object to release memory
rm(list = c("bf"))
gc()
}
