% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secrets.R
\name{db_secrets_scope_create}
\alias{db_secrets_scope_create}
\title{Create Secret Scope}
\usage{
db_secrets_scope_create(
  scope,
  initial_manage_principal = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{scope}{Scope name requested by the user. Scope names are unique.}

\item{initial_manage_principal}{The principal that is initially granted
\code{MANAGE} permission to the created scope.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Create Secret Scope
}
\details{
Create a Databricks-backed secret scope in which secrets are stored in
Databricks-managed storage and encrypted with a cloud-based specific
encryption key.

The scope name:
\itemize{
\item Must be unique within a workspace.
\item Must consist of alphanumeric characters, dashes, underscores, and periods,
and may not exceed 128 characters.
}

The names are considered non-sensitive and are readable by all users in the
workspace. A workspace is limited to a maximum of 100 secret scopes.

If \code{initial_manage_principal} is specified, the initial ACL applied to the
scope is applied to the supplied principal (user or group) with \code{MANAGE}
permissions. The only supported principal for this option is the group users,
which contains all users in the workspace. If \code{initial_manage_principal} is
not specified, the initial ACL with \code{MANAGE} permission applied to the scope
is assigned to the API request issuer’s user identity.
\itemize{
\item Throws \code{RESOURCE_ALREADY_EXISTS} if a scope with the given name already
exists.
\item Throws \code{RESOURCE_LIMIT_EXCEEDED} if maximum number of scopes in the
workspace is exceeded.
\item Throws \code{INVALID_PARAMETER_VALUE} if the scope name is invalid.
}
}
\seealso{
Other Secrets API: 
\code{\link{db_secrets_delete}()},
\code{\link{db_secrets_list}()},
\code{\link{db_secrets_put}()},
\code{\link{db_secrets_scope_acl_delete}()},
\code{\link{db_secrets_scope_acl_get}()},
\code{\link{db_secrets_scope_acl_list}()},
\code{\link{db_secrets_scope_acl_put}()},
\code{\link{db_secrets_scope_delete}()},
\code{\link{db_secrets_scope_list_all}()}
}
\concept{Secrets API}
