% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remote-repl.R
\name{db_context_manager}
\alias{db_context_manager}
\title{Databricks Execution Context Manager (R6 Class)}
\description{
Databricks Execution Context Manager (R6 Class)

Databricks Execution Context Manager (R6 Class)
}
\details{
\code{db_context_manager()} provides a simple interface to send commands to
Databricks cluster and return the results.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-databricks_context_manager-new}{\code{db_context_manager$new()}}
\item \href{#method-databricks_context_manager-close}{\code{db_context_manager$close()}}
\item \href{#method-databricks_context_manager-cmd_run}{\code{db_context_manager$cmd_run()}}
\item \href{#method-databricks_context_manager-clone}{\code{db_context_manager$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-databricks_context_manager-new"></a>}}
\if{latex}{\out{\hypertarget{method-databricks_context_manager-new}{}}}
\subsection{Method \code{new()}}{
Create a new context manager object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{db_context_manager$new(
  cluster_id,
  language = c("r", "py", "scala", "sql", "sh"),
  host = db_host(),
  token = db_token()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cluster_id}}{The ID of the cluster to execute command on.}

\item{\code{language}}{One of \code{r}, \code{py}, \code{scala}, \code{sql}, or \code{sh}.}

\item{\code{host}}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{\code{token}}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{databricks_context_manager} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-databricks_context_manager-close"></a>}}
\if{latex}{\out{\hypertarget{method-databricks_context_manager-close}{}}}
\subsection{Method \code{close()}}{
Destroy the execution context
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{db_context_manager$close()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-databricks_context_manager-cmd_run"></a>}}
\if{latex}{\out{\hypertarget{method-databricks_context_manager-cmd_run}{}}}
\subsection{Method \code{cmd_run()}}{
Execute a command against a Databricks cluster
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{db_context_manager$cmd_run(cmd, language = c("r", "py", "scala", "sql", "sh"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cmd}}{code to execute against Databricks cluster}

\item{\code{language}}{One of \code{r}, \code{py}, \code{scala}, \code{sql}, or \code{sh}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Command results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-databricks_context_manager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-databricks_context_manager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{db_context_manager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
