% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{db_jobs_runs_list}
\alias{db_jobs_runs_list}
\title{List Job Runs}
\usage{
db_jobs_runs_list(
  job_id,
  active_only = FALSE,
  completed_only = FALSE,
  offset = 0,
  limit = 25,
  run_type = c("JOB_RUN", "WORKFLOW_RUN", "SUBMIT_RUN"),
  expand_tasks = FALSE,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{job_id}{The canonical identifier of the job.}

\item{active_only}{Boolean (Default: \code{FALSE}). If \code{TRUE} only active runs are
included in the results; otherwise, lists both active and completed runs.
An active run is a run in the \code{PENDING}, \code{RUNNING}, or \code{TERMINATING}. This
field cannot be true when \code{completed_only} is \code{TRUE}.}

\item{completed_only}{Boolean (Default: \code{FALSE}). If \code{TRUE}, only completed
runs are included in the results; otherwise, lists both active and completed
runs. This field cannot be true when \code{active_only} is \code{TRUE}.}

\item{offset}{The offset of the first job to return, relative to the most
recently created job.}

\item{limit}{Number of jobs to return. This value must be greater than 0 and
less or equal to 25. The default value is 25. If a request specifies a limit
of 0, the service instead uses the maximum limit.}

\item{run_type}{The type of runs to return. One of \code{JOB_RUN}, \code{WORKFLOW_RUN},
\code{SUBMIT_RUN}.}

\item{expand_tasks}{Whether to include task and cluster details in the
response.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
List runs in descending order by start time.
}
\seealso{
Other Jobs API: 
\code{\link{db_jobs_create}()},
\code{\link{db_jobs_delete}()},
\code{\link{db_jobs_get}()},
\code{\link{db_jobs_list}()},
\code{\link{db_jobs_reset}()},
\code{\link{db_jobs_run_now}()},
\code{\link{db_jobs_runs_cancel}()},
\code{\link{db_jobs_runs_delete}()},
\code{\link{db_jobs_runs_export}()},
\code{\link{db_jobs_runs_get}()},
\code{\link{db_jobs_runs_get_output}()},
\code{\link{db_jobs_runs_submit}()},
\code{\link{db_jobs_update}()}
}
\concept{Jobs API}
