% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_group_fit.R
\name{stan_group_fit}
\alias{stan_group_fit}
\title{Bayesian Stan fit to 13C Breath Data in Multiple Groups}
\usage{
stan_group_fit(data, dose = 100, sample_minutes = 15,
  student_t_df = 10, chains = 2, iter = 1000,
  model = "breath_test_group_1")
}
\arguments{
\item{data}{Data frame or tibble as created by \code{\link[breathtestcore]{cleanup_data}},
with mandatory columns \code{patient_id, group, minute} and \code{pdr}.
It is recommended to run all data through \code{\link[breathtestcore]{cleanup_data}} which
will insert dummy columns for \code{patient_id} and \code{minute} if the
data are distinct, and report an error if not. Since the Bayesian method
is stabilized by priors, it is possible to fit single curves.}

\item{dose}{Dose of acetate or octanoate. Currently, only one common dose
for all records is supported.}

\item{sample_minutes}{If mean sampling interval is < sampleMinutes, data are subsampled
using a spline algorithm}

\item{student_t_df}{When student_t_df < 10, the student distribution is used to
model the residuals. Recommended values to model typical outliers are from 3 to 6.
When student_t_df >= 10, the normal distribution is used.}

\item{chains}{Number of chains for Stan}

\item{iter}{Number of iterations for each Stan chain}

\item{model}{Name of model; use \code{names(stanmodels)} for other models.}
}
\value{
A list of classes "breathteststangroupfit", "breathteststanfit" and "breathtestfit"
with elements
\itemize{
  \item {\code{coef} Estimated parameters as data frame in a key-value format with
   columns \code{patient_id, group, parameter, method} and \code{value}.
   Has an attribute AIC.}
   \item {\code{data}  The effectively analyzed data. If density of points
   is too high, e.g. with BreathId devices, data are subsampled before fitting.}
   \item {\code{stan_fit} The Stan fit for use with \code{shinystan::launch_shiny}
   or extraction of chains. }
}
}
\description{
Fits exponential beta curves to 13C breath test series
data using Bayesian Stan methods, by assuming fixed between group effects.
This model is overly parsiomonious. Do not use it
unless you check the results carefully and understand why
fits can be very bad.
}
\examples{
\donttest{
library(breathtestcore)
library(dplyr)
data("usz_13c", package = "breathtestcore")
data = usz_13c \%>\%
  dplyr::filter( patient_id \%in\%
       c("norm_001", "norm_002", "norm_003", "norm_004",
         "pat_001", "pat_002","pat_003")) \%>\%
  breathtestcore::cleanup_data()
fit = stan_group_fit(data, chains = 1, iter = 100)
plot(fit) # calls plot.breathtestfit
coef(fit)
}

}
\seealso{
Base methods \code{coef, plot, print}; methods from package
 \code{broom: tidy, augment}.
}
