% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NOT.R
\name{sol.not}
\alias{sol.not}
\title{Solution path generation via the Narrowest-Over-Threshold method}
\usage{
sol.not(x, M = 10000, systematic.intervals = TRUE, seed = NULL)
}
\arguments{
\item{x}{A numeric vector containing the data to be processed}

\item{M}{The maximum number of all data sub-samples at the beginning of the algorithm. The default is
\code{M = 10000}}

\item{systematic.intervals}{When drawing the sub-intervals, whether to use a systematic (and fixed) or random scheme. The default is \code{systematic.intervals = TRUE}}

\item{seed}{If a random scheme is used, a random seed can be provided so that every time the same sets of random sub-intervals would be drawn. The default is \code{seed = NULL}, which means that this option is not taken}
}
\value{
An S3 object of class \code{cptpath}, which contains the following fields: 
\item{solutions.nested}{\code{FALSE}, i.e., the change-point outputs are not nested}
\item{solution.path}{Empty list}
\item{solution.set}{Locations of possible change-points in the mean of \code{x} for each threshold level (in the decreasing order), arranged in the form of a list of lists}
\item{solution.set.th}{A list that contains threshold levels corresponding to the detections in \code{solution.set}}
\item{x}{Input vector \code{x}}
\item{M}{Input parameter \code{M}}
\item{cands}{Matrix of dimensions length(\code{x}) - 1 by 4. The first two columns are (start, end)-points of the detection intervals of the corresponding possible change-point location in the third column resulted from applying NOT to all threshold levels. The fourth column is a measure of strength of the corresponding possible change-point. The order of the rows reflect the strength of each detection in decreasing order. To avoid repetition, each possible location would appear at most once in the matrix (with the sub-interval that carries its highest possible strength)}
\item{method}{The method used, which has value "not" here}
}
\description{
This function arranges all possible change-points in the mean of the input vector in the order of importance, via the Narrowest-Over-Threshold (NOT) method.
}
\details{
The Narrowest-Over-Threshold method and its algorithm is described in 
"Narrowest-over-threshold detection of multiple change points and change-point-like features", R. Baranowski, Y. Chen and P. Fryzlewicz (2019), Journal of Royal Statistical Society: Series B, 81(3), 649--672.
}
\examples{
r3 <- rnorm(1000) + c(rep(0,300), rep(2,200), rep(-4,300), rep(0,200))
sol.not(r3)
}
\references{
R. Baranowski, Y. Chen & P. Fryzlewicz (2019). Narrowest-over-threshold detection of multiple change points and change-point-like features. \emph{Journal of the Royal Statistical Society: Series B}, 81(3), 649--672.
}
\seealso{
\code{\link{sol.idetect}}, \code{\link{sol.tguh}}, \code{\link{sol.wbs}},  \code{\link{sol.wbs2}}
}
