% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tguh_reconstr.R
\name{tguh.reconstr}
\alias{tguh.reconstr}
\title{The inverse Tail-Greedy Unbalanced Haar transformation}
\usage{
tguh.reconstr(tguh.decomp.obj)
}
\arguments{
\item{tguh.decomp.obj}{A variable returned by \code{tguh.decomp} or \code{tguh.denoise}.}
}
\value{
A vector being the result of the inverse Tail-Greedy Unbalanced Haar transformation of \code{tghu.decomp.obj}.
}
\description{
This function performs the inverse Tail-Greedy Unbalanced Haar transformation,
also referred to as reconstruction.
}
\details{
The Tail-Greedy Unbalanced Haar decomposition and reconstruction algorithms are described in 
"Tail-greedy bottom-up data decompositions and fast multiple change-point 
detection", P. Fryzlewicz (2017), preprint.
}
\examples{
rnoise <- rnorm(10)
rnoise.tguh <- tguh.decomp(rnoise)
print(rnoise.tguh)
rnoise.denoise <- tguh.denoise(rnoise.tguh, 3)
rnoise.clean <- tguh.reconstr(rnoise.denoise)
print(rnoise.clean)
}
\seealso{
\code{\link{tguh.cpt}}, \code{\link{tguh.decomp}}, \code{\link{tguh.denoise}}
}
\author{
Piotr Fryzlewicz, \email{p.fryzlewicz@lse.ac.uk}
}
