% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_report.R
\name{create_report}
\alias{create_report}
\title{Create a HTML report for a municipality}
\usage{
create_report(
  code_muni,
  date_start,
  date_end,
  temp_max_min_avg = TRUE,
  temp_max_min_sd = FALSE,
  prec_sum = TRUE,
  prec_avg = FALSE,
  prec_sd = FALSE,
  eto_sum = TRUE,
  eto_avg = FALSE,
  eto_sd = FALSE,
  rh_avg = TRUE,
  rh_sd = FALSE,
  rs_avg = TRUE,
  rs_sd = FALSE,
  u2_avg = TRUE,
  u2_sd = FALSE,
  set_title = NULL,
  output_format = rmarkdown::html_document(theme = "yeti"),
  output_file = "report.html",
  output_dir = getwd()
)
}
\arguments{
\item{code_muni}{IBGE municipality code number with 7 digits.}

\item{date_start}{A date.}

\item{date_end}{A date, >= than \code{date_start}.}

\item{temp_max_min_avg}{Logical, plot max and min average}

\item{temp_max_min_sd}{Logical, plot max and min standard deviation.}

\item{prec_sum}{Logical, plot precipitation sum.}

\item{prec_avg}{Logical, plot precipitation average.}

\item{prec_sd}{Logical, plot precipitation standard deviation.}

\item{eto_sum}{Logical, plot evapotranspiration sum.}

\item{eto_avg}{Logical, plot evapotranspiration average.}

\item{eto_sd}{Logical, plot evapotranspiration standard deviation.}

\item{rh_avg}{Logical, plot relative humidity average.}

\item{rh_sd}{Logical, plot relative humidity standard deviation.}

\item{rs_avg}{Logical, plot solar radiation average.}

\item{rs_sd}{Logical, plot solar radiation standard deviation.}

\item{u2_avg}{Logical, plot wind speed average.}

\item{u2_sd}{Logical, plot wind speed standard deviation.}

\item{set_title}{Report title. If \code{NULL}, the municipality code will be used.}

\item{output_format}{A \code{rmarkdown::html_document} object.}

\item{output_file}{Output file name.}

\item{output_dir}{Output file address. Defaults to current address from \code{getwd()}.}
}
\value{
A HTML file.
}
\description{
Create a HTML report for a municipality
}
