% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bits.r
\name{bits}
\alias{bits}
\title{Bayesian Iterated Screening (ultra-high, high or low dimensional).}
\usage{
bits(X, y, lam = 1, w = 0.5, pp = FALSE, max.var = nrow(X))
}
\arguments{
\item{X}{An \eqn{n\times p} matrix. Sparse matrices are supported and every
care is taken not to make copies of this (typically) giant matrix.
No need to center or scale.}

\item{y}{The response vector of length \code{n}.}

\item{lam}{The slab precision parameter. Default: \code{1}.}

\item{w}{The prior inclusion probability of each variable. Default: \code{1/2}.}

\item{pp}{Boolean: If \code{FALSE} (default) the algorithm stops after including \code{max.var} many variables.
If true, the posterior probability stopping rule is used.}

\item{max.var}{The maximum number of variables to be included.}
}
\value{
A list with components
\item{model.pp}{An integer vector of the screened model.}
\item{postprobs}{The sequence of posterior probabilities until the last included variable.}
\item{lam}{The value of lam, the slab precision parameter.}
\item{w}{The value of w, the prior inclusion probability.}
}
\description{
Perform Bayesian iterated screening in Gaussian regression models
}
\examples{
n=50; p=100;
TrueBeta <- c(rep(5,3),rep(0,p-3))

rho <- 0.6
x1 <- matrix(rnorm(n*p), n, p)
X <- sqrt(1-rho)*x1 + sqrt(rho)*rnorm(n)
y <- 0.5 + X \%*\% TrueBeta + rnorm(n)
res<-bits(X,y, pp=TRUE)
res$model.pp # the vector of screened model
res$postprobs # the log (unnormalized) posterior probabilities corresponding to the model.pp.
}
\references{
Wang, R., Dutta, S., Roy, V. (2021) Bayesian iterative screening in ultra-high dimensional 
settings. https://arxiv.org/abs/2107.10175
}
