% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_sID}
\alias{check_sID}
\alias{pad_zeros}
\title{Test if an object is a character vector of numbers}
\usage{
check_sID(x)

pad_zeros(x)
}
\arguments{
\item{x}{\code{pad_zeros} accepts either a vector (numeric or character) or a
single integer. \code{check_sID} accepts a character, numeric, or factor
vector}
}
\value{
\code{check_sID} returns either the input vector or a character
  vector padded with \code{0}

A character vector with zero-padded values
}
\description{
\code{check_sID} is a convenience function to test if a vector (typically the
\emph{subject ID} column in a \code{data.table}) is a character vector of
numbers, a factor vector of numbers, or a numeric vector. If so, it will
zero-pad the variable to have equal width.

\code{pad_zeros} pads a vector with zeros to avoid issues with ordering a
column of integers or integers converted to \code{character}.
}
\details{
This function is meant to avoid issues that arise when sorting a vector of
numbers that have been converted to \code{character}. For example,
\code{\link{import_scn}} automatically reads in the first column (with
\emph{FreeSurfer} outputs this is the column of subject IDs) as a
\code{character} variable. If the subject IDs had been all numbers/integers,
then sorting (i.e., setting the \code{key} in a \code{data.table}) would be
incorrect: e.g., it might be \code{'1', '10', '2', ...}.

If \dQuote{x} is a numeric vector, then the resultant string width will be
determined by \code{max(x)} or \code{x} itself if the input is a single
integer. For example, if \code{x=10}, it will return \code{'01', '02', ...,
'10'}. If \dQuote{x} is a character vector, then the output's string width
will be \code{max(nchar(x))}. For example, if \code{x} includes both
\code{'1'} and \code{'1000'}, it will return \code{'0001'}, etc.
}
\examples{
pad_zeros(10)  # '01' '02' ... '10'
x <- c(1, 10, 100)
pad_zeros(x)   # '001' '010' '100'
x <- as.character(x)
pad_zeros(x)   # '001' '010' '100'
}
