% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_efficiency.R
\name{graph.efficiency}
\alias{graph.efficiency}
\title{Calculate graph global, local, or nodal efficiency}
\usage{
graph.efficiency(g, type = c("local", "nodal", "global"), weights = NULL,
  .parallel = TRUE)
}
\arguments{
\item{g}{The graph on which to calculate efficiency}

\item{type}{A character string; either 'local', 'nodal', or 'global'}

\item{weights}{A numeric vector of edge weights; if 'NULL', and if the graph
has edge attribute 'weight', then that will be used. To avoid using weights,
this should be 'NA'}

\item{.parallel}{Logical indicating whether or not to use \code{foreach}
(default: TRUE)}
}
\value{
A vector of the local efficiencies for each vertex of the graph (if
\emph{type} is 'local|nodal') or a number (if \emph{type} is 'global').
}
\description{
This function calculates the global efficiency of a graph or the local or
nodal efficiency of each vertex of a graph. The global efficiency is equal
to the mean of all nodal efficiencies.
}
\details{
Global efficiency for graph \emph{G} with \emph{N} vertices is:
\deqn{E_{global}(G) = \frac{1}{N(N-1)} \sum_{i \ne j \in G} \frac{1}{d_{ij}}}
where \eqn{d_{ij}} is the shortest path length between vertices \emph{i} and
\emph{j}.

Local efficiency for vertex \emph{i} is:
\deqn{E_{local}(i) = \frac{1}{N} \sum_{i \in G} E_{global}(G_i)}
where \eqn{G_i} is the subgraph of neighbors of \emph{i}, and \emph{N} is the
number of vertices in that subgraph.

Nodal efficiency for vertex \emph{i} is:
\deqn{E_{nodal}(i) = \frac{1}{N-1} \sum_{j \in G} \frac{1}{d_{ij}}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\references{
Latora V., Marchiori M. (2001) \emph{Efficient behavior of
small-world networks}. Phys Rev Lett, 87.19:198701.
}

