% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glob.R
\name{glob}
\alias{glob}
\title{Brace and Wildcard expansion on file paths}
\usage{
glob(paths, ...)
}
\arguments{
\item{paths}{character vector of patterns for relative or absolute filepaths.}

\item{...}{Passed to \code{Sys.glob}}
}
\description{
\code{glob} is a wrapper around \code{Sys.glob} that uses
\code{expand_braces} to support both brace and wildcard
expansion on file paths.
}
\examples{
  dir <- system.file("R", package="bracer")
  path <- file.path(dir, "*.{R,r,S,s}")
  glob(path)
}
