% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxr_comment.R
\name{box_comment_create}
\alias{box_comment_create}
\alias{box_comment_get}
\title{Create/get Box comments}
\usage{
box_comment_create(file_id = NULL, message, comment_id = NULL)

box_comment_get(file_id)
}
\arguments{
\item{file_id}{\code{numeric} or \code{character}, file ID at Box.}

\item{message}{\code{character} contents of comment.
Note: tagging people with the @user pattern is \emph{not} yet supported.}

\item{comment_id}{\code{numeric} or \code{character}, comment ID at Box.}
}
\value{
\describe{
\item{\code{box_comment_create()}}{
Object with S3 class \code{\link[=boxr_S3_classes]{boxr_comment}}.}
\item{\code{box_comment_get()}}{
Object with S3 class \code{\link[=boxr_S3_classes]{boxr_comment_list}}.}
}
}
\description{
Use these functions to create and get comments for Box files.
}
\details{
When you create a comment using \code{box_comment_create()}, you have to specify
a \code{file_id} or a \code{comment_id}. If you specify a \code{comment_id}, the comment
will be posted as a reply to that comment.

Use \code{box_comment_get()} to retrieve comments in bulk. This gets all the
comments associated with a file, thus you can specify only a  \code{file_id}.
}
\examples{
\dontrun{
  file_id <- 12345
  
  # create comments
  x <- box_comment_create(file_id, "Report is ready.")
  box_comment_create(comment_id = x$id, message = "Response to a comment")
  
  # get comments
  box_comment_get(file_id)
}
}
