% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis.R
\name{kinesis_get_records}
\alias{kinesis_get_records}
\title{Gets data records from a Kinesis data stream's shard}
\usage{
kinesis_get_records(shard_iterator, limit = 25L)
}
\arguments{
\item{shard_iterator}{the position in the shard from which you want to start sequentially reading data records, usually provided by \code{\link{kinesis_get_shard_iterator}}}

\item{limit}{maximum number of records to return}
}
\value{
list of \code{Records}, \code{NextShardIterator} and \code{MillisBehindLatest}
}
\description{
Gets data records from a Kinesis data stream's shard
}
\examples{
\dontrun{
botor(profile_name = 'botor-tester')
iterator <- kinesis_get_shard_iterator(stream = 'botor-tester', shard = '0')
kinesis_get_records(iterator$ShardIterator)
}
}
\references{
\url{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/kinesis.html#Kinesis.Client.get_records}
}
