% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optifix.R
\name{optifix}
\alias{optifix}
\title{optifix. Optimise with some fixed parameters}
\usage{
optifix(parms, fixed, fn, gr = NULL, ..., method = c("Nelder-Mead", "BFGS",
  "CG", "L-BFGS-B", "SANN"), lower = -Inf, upper = Inf, control = list(),
  hessian = FALSE)
}
\arguments{
\item{parms}{Parameters to potentially optimize in \code{fn}}

\item{fixed}{A vector of TRUE/FALSE values indicating which parameters in \code{parms} to hold constant (not optimize). If TRUE, the corresponding parameter in fn() is fixed. Otherwise it's variable and optimised over.}

\item{fn}{Function to optimize (same as in \code{\link[stats]{optim}})}

\item{gr}{Gradient function (same as in \code{\link[stats]{optim}})}

\item{...}{Further arguments to be passed to fn and gr.}

\item{method}{Method to use for optimization (same as in \code{\link[stats]{optim}})}

\item{lower}{Lower limits (same as in \code{\link[stats]{optim}})}

\item{upper}{Upper limits (same as in \code{\link[stats]{optim}})}

\item{control}{Control list (same as in \code{\link[stats]{optim}})}

\item{hessian}{Return Hessian object (same as in \code{\link[stats]{optim}})}
}
\value{
Similar to \code{\link[stats]{optim}} but adds a vector of all the parameters and a vector copy of the 'fixed' argument.
}
\description{
Like \code{\link[stats]{optim}}, but with option to fix some parameters.
}
\details{
Originally written by Barry Rowlingson"
}
\author{
Written by Barry Rowlingson October 2011
}
\references{
\url{http://www.maths.lancs.ac.uk/~rowlings/R/Optifix/optifix.R}
}

