% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntalTille_UPS.R
\name{AntalTille2011_ups}
\alias{AntalTille2011_ups}
\title{Antal and Tillé (2011) Bootstrap for Unequal Probability Sampling without replacement}
\usage{
AntalTille2011_ups(
  ys,
  pks,
  B,
  smplFUN,
  approx_method = c("Hajek", "DevilleTille")
)
}
\arguments{
\item{ys}{values of the variable of interest for the original sample}

\item{pks}{vector of first-order inclusion probabilities for sampled units}

\item{B}{integer scalar, number of bootstrap resamples to draw from the pseudo-population}

\item{smplFUN}{a function that takes as input a vector of length N of 
inclusion probabilities and return a vector of length N, either logical or a 
vector of 0s and 1s,  where \code{TRUE} or \code{1} indicate sampled
units and \code{FALSE} or \code{0} indicate non-sample units.}

\item{approx_method}{method used to approximate the variance Dkk.}
}
\value{
a list of two elements, a vector of K average bootstrap totals and
a vector of K variance estimates.
}
\description{
Draw B bootstrap samples according to Antal and Tillé (2011) direct
bootstap method for Unequal Probability Sampling.
Note that this method does not need a double bootstrap.
}
\references{
Antal, E.; Tillé, Y., 2011. A Direct Bootstrap Method for Complex Sampling
Designs From a Finite Population. Journal of the American Statistical Association, 106:494, 534-543,
doi: 10.1198/jasa.2011.tm09767

Antal, E.; Tillé, Y., 2014. A new resampling method for sampling designs without
replacement: the doubled half bootstrap. Computational Statistics, 29(5), 1345-1363.
doi: 10.10007/s00180-014-0495-0
}
\keyword{internal}
