% Generated by roxygen2 (4.0.0): do not edit by hand
\name{predictClassFromWeightedVote}
\alias{predictClassFromVote}
\alias{predictClassFromWeightedVote}
\title{Predict a class using (un)weighted voting.}
\usage{
predictClassFromWeightedVote(preds, weights, .parallel = FALSE,
  .rngSeed = 1234)

predictClassFromVote(preds, .parallel = FALSE, .rngSeed = 1234)
}
\arguments{
\item{preds}{is (character) matrix of predicted classes}

\item{weights}{is a vector of length equal to \code{nrow(preds)}}

\item{.parallel}{is a boolean flag determining whether to work
across columns of \code{preds} in parallel -- need to register a
parallel backend (e.g. \code{doParallel}, \code{doRedis}) for this to
actually work.}

\item{.rngSeed}{the value of the RNG seed to be used in the case that
ties are to be randomly broken.}
}
\value{
a character vector of length equal to \code{ncol(preds)} containing
the class estimates per column of \code{preds}.
}
\description{
Process a matrix of class predictions and form a column-wise
estimate based on weighted voting.
}
\details{


Gives the vote from row(i) in \code{preds} weight equal to
\code{weights[i]}. Ties are broken randomly, but before so, the seed is set
to \code{.rngSeed}.
}

