% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_current_weather.R
\name{get_current_weather}
\alias{get_current_weather}
\title{Get current weather observations of a BOM station}
\usage{
get_current_weather(
  station_name,
  strict = FALSE,
  latlon = NULL,
  emit_latlon_msg = TRUE
)
}
\arguments{
\item{station_name}{The name of the weather station. Fuzzy string matching
via \code{\link[base]{agrep}} is done.}

\item{strict}{(logical) If \code{TRUE}, \var{station_name} must match the
station name exactly, except that \var{station_name} need not be upper case.
Note this may be different to \code{full_name} in the response. See
\strong{Details}.}

\item{latlon}{A length-2 numeric vector giving the decimal degree
latitude and longitude (in that order), \emph{e.g.}, \code{latlon =
c(-34, 151)} for Sydney. When given instead of \code{station_name}, the
nearest station (in this package) is used, with a message indicating the
nearest such station. (See also \code{\link{sweep_for_stations}}.) Ignored if
used in combination with \var{station_name}, with a warning.}

\item{emit_latlon_msg}{Logical. If \code{TRUE} (the default), and
\code{latlon} is selected, a message is emitted before the table is returned
indicating which station was actually used (\emph{i.e.}, which station was
found to be nearest to the given coordinate).}
}
\value{
A \code{bomrang_tbl} object (extension of a
\code{\link[base]{data.frame}})  of requested BOM station's current and prior
 72hr data. For full details of fields and units returned, see Appendix 1
 in the \pkg{bomrang} vignette, use \cr
\code{vignette("bomrang", package = "bomrang")} to view.
}
\description{
Get current weather observations of a BOM station
}
\details{
Station names are not consistently named within the Bureau, so
the response may contain a different \code{full_name} to the one
matched, even if \var{strict = TRUE}. For example, \cr
\code{get_current_weather("CASTLEMAINE PRISON")[["full_name"]][1]} \cr
is \code{Castlemaine}, not \code{Castlemaine Prison}.

Note that the column \code{local_date_time_full} is set to a
\code{POSIXct} object in the local time of the \strong{user}.
For more details see "Appendix 1 - Output from get_current_weather()" in
the \pkg{bomrang} vignette \cr
\code{vignette("bomrang", package = "bomrang")}\cr
for a complete list of fields and units.
}
\examples{
\donttest{
  # warning
  Melbourne_weather <- get_current_weather("Melbourne")

  # no warning
  Melbourne_weather <- get_current_weather("Melbourne (Olympic Park)")

  # Get weather by latitude and longitude:
  get_current_weather(latlon = c(-34, 151))
}
}
\references{
Weather data observations are retrieved from:
Australian Bureau of Meteorology (\acronym{BOM}) Weather Data Services,
Observations - individual stations:
\url{http://www.bom.gov.au/catalogue/data-feeds.shtml}

Station location and other metadata are sourced from the Australian Bureau of
Meteorology (\acronym{BOM}) webpage, Bureau of Meteorology Site Numbers:
\url{http://www.bom.gov.au/climate/cdo/about/site-num.shtml}
}
\author{
Hugh Parsonage, \email{hugh.parsonage@gmail.com}
}
