% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boiwsa.R
\name{boiwsa}
\alias{boiwsa}
\title{Seasonal adjustment of weekly data}
\usage{
boiwsa(
  x,
  dates,
  r = 0.8,
  auto.ao.seacrh = TRUE,
  out.threshold = 3.8,
  ao.list = NULL,
  my.k_l = NULL,
  H = NULL,
  ic = "aicc",
  method = "additive"
)
}
\arguments{
\item{x}{Input time series as a numeric vector}

\item{dates}{a vector of class "Date", containing the data dates}

\item{r}{Defines the rate of decay of the weights. Should be between zero and one. By default is set to 0.8.}

\item{auto.ao.seacrh}{Boolean. Search for additive outliers}

\item{out.threshold}{t-stat threshold in outlier search. By default is 3.8}

\item{ao.list}{Vector with user specified additive outliers in a date format}

\item{my.k_l}{Numeric vector defining the number of yearly and monthly trigonometric variables. If NULL, is found automatically using the information criteria}

\item{H}{Matrix with holiday- and trading day factors}

\item{ic}{Information criterion used in the automatic search for the number of trigonometric regressors. There are thee options: aic, aicc and bic. By default uses aicc}

\item{method}{Decomposition type: additive or multiplicative}
}
\value{
sa Seasonally adjusted series

my.k_l Number of trigonometric variables used to model the seasonal pattern

sf Estimated seasonal effects

hol.factors Estimated holiday effects

out.factors Estimated outlier effects

beta Regression coefficients for the last year

m lm object. Unweighted OLS regression on the full sample
}
\description{
Seasonal adjustment of weekly data
}
\examples{
 # Not run
 # Seasonal adjustment of weekly US gasoline production
 \donttest{
 data("gasoline.data")
 res=boiwsa(x=gasoline.data$y,dates=gasoline.data$date)}
}
\author{
Tim Ginker
}
