% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tite.boinet.R
\name{tite.boinet}
\alias{tite.boinet}
\title{Conducting simulation study of TITE-BOIN-ET design}
\usage{
tite.boinet(
  n.dose, start.dose, size.cohort, n.cohort,
  toxprob, effprob,
  phi=0.3, phi1=phi*0.1, phi2=phi*1.4, delta=0.6, delta1=delta*0.6,
  alpha.T1=0.5, alpha.E1=0.5, tau.T, tau.E,
  te.corr=0.2, gen.event.time="weibull",
  accrual, gen.enroll.time="uniform",
  stopping.npts=size.cohort*n.cohort,
  stopping.prob.T=0.95, stopping.prob.E=0.99,
  estpt.method, obd.method,
  w1= 0.33, w2=1.09,
  plow.ast=phi1, pupp.ast=phi2, qlow.ast=delta1/2, qupp.ast=delta,
  psi00=40, psi11=60,
  n.sim=1000, seed.sim=100)
}
\arguments{
\item{n.dose}{Number of dose.}

\item{start.dose}{Starting dose. The lowest dose is generally recommended.}

\item{size.cohort}{Cohort size.}

\item{n.cohort}{Number of cohort.}

\item{toxprob}{Vector of true toxicity probability.}

\item{effprob}{Vector of true efficacy probability.}

\item{phi}{Target toxicity probability. The default value is
\code{phi=0.3}.}

\item{phi1}{Highest toxicity probability that is deemed sub-therapeutic such
that dose-escalation should be pursued. The default value is
\code{phi1=phi*0.1}.}

\item{phi2}{Lowest toxicity probability that is deemed overly toxic such that
dose de-escalation is needed. The default value is \code{phi2=phi*1.4}.}

\item{delta}{Target efficacy probability. The default value is
\code{delta=0.6}.}

\item{delta1}{Minimum probability deemed efficacious such that the dose
levels with less than delta1 are considered sub-therapeutic.
The default value is \code{delta1=delta*0.6}.}

\item{alpha.T1}{Probability that toxicity event occurs in the late half of
toxicity assessment window. The default value is \code{alpha.T1=0.5}.}

\item{alpha.E1}{Probability that efficacy event occurs in the late half of
assessment window. The default value is \code{alpha.E1=0.5}.}

\item{tau.T}{Toxicity assessment windows (days).}

\item{tau.E}{Efficacy assessment windows (days).}

\item{te.corr}{Correlation between toxicity and efficacy probability,
specified as Gaussian copula parameter. The default value is
\code{te.corr=0.2}.}

\item{gen.event.time}{Method to generate the time to first toxicity and
efficacy outcome. Weibull distribution is used when
\code{gen.event.time="weibull"}. Uniform distribution is used when
\code{gen.event.time="uniform"}. The default value is
\code{gen.event.time=weibull}.}

\item{accrual}{Accrual rate (days) (average number of days necessary to
enroll one patient).}

\item{gen.enroll.time}{Method to generate enrollment time. Uniform
distribution is used when \code{gen.enroll.time="uniform"}. Exponential
distribution is used when \code{gen.enroll.time="exponential"}. The default
value is \code{gen.enroll.time="uniform"}.}

\item{stopping.npts}{Early study termination criteria. If the number of
patients at the current dose reaches this criteria, the study is terminated.
The default value is \code{stopping.npts=size.cohort*n.cohort}.}

\item{stopping.prob.T}{Early study termination criteria for toxicity,
taking a value between 0 and 1. If the posterior probability that toxicity
outcome is less than the target toxicity probability (phi) is larger than
this criteria, the dose levels are eliminated from the study. The default
value is \code{stopping.prob.T=0.95}.}

\item{stopping.prob.E}{Early study termination criteria for efficacy,
taking a value between 0 and 1. If the posterior probability that efficacy
outcome is less than the minimum efficacy probability (delta1) is larger
then this criteria, the dose levels are eliminated from the study.
The default value is \code{stopping.prob.E=0.99}.}

\item{estpt.method}{Method to estimate the efficacy probability. Fractional
polynomial logistic regression is used when \code{estpt.method="fp.logistic"}.
Model averaging of multiple unimodal isotopic regression is used when
\code{estpt.method="multi.iso"}. Observed efficacy probability is used when
\code{estpt.method="obs.prob"}.}

\item{obd.method}{Method to select the optimal biological dose. Utility
defined by weighted function is used when \code{obd.method="utility.weighted"}.
Utility defined by truncated linear function is used when
\code{obd.method="utility.truncated.linear"}. Utility defined by scoring is
used when \code{obd.method="utility.scoring"}. Highest estimated efficacy
probability is used when \code{obd.method="max.effprob"}.}

\item{w1}{Weight for toxicity-efficacy trade-off in utility defined by
weighted function. This must be specified when using
\code{obd.method="utility.weighted"}. The default value is \code{w1=0.33}.}

\item{w2}{Weight for penalty imposed on toxic doses in utility defined by
weighted function. This must be specified when using
\code{obd.method="utility.weighted"}. The default value is \code{w2=1.09}.}

\item{plow.ast}{Lower threshold of toxicity linear truncated function. This
must be specified when using \code{obd.method="utility.truncated.linear"}.
The default value is \code{plow.ast=phi1}.}

\item{pupp.ast}{Upper threshold of toxicity linear truncated function. This
must be specified when using \code{obd.method="utility.truncated.linear"}.
The default value is \code{pupp.ast=phi2}.}

\item{qlow.ast}{Lower threshold of efficacy linear truncated function. This
must be specified when using \code{obd.method="utility.truncated.linear"}.
The default value is \code{qlow.ast=delta1/2}.}

\item{qupp.ast}{Upper threshold of efficacy linear truncated function. This
must be specified when using \code{obd.method="utility.truncated.linear"}.
The default value is \code{qupp.ast=delta}.}

\item{psi00}{Score for toxicity=no and efficacy=no in utility defined by
scoring. This must be specified when using \code{obd.method="utility.scoring"}.
The default value is \code{psi00=40}.}

\item{psi11}{Score for toxicity=yes and efficacy=yes in utility defined by
scoring. This must be specified when using \code{obd.method="utility.scoring"}.
The default value is \code{psi11=60}.}

\item{n.sim}{Number of simulated trial. The default value is
\code{n.sim=1000}.}

\item{seed.sim}{Seed for random number generator. The default value is
\code{seed.sim=100}.}
}
\value{
The \code{tite.boinet} returns a list containing the following components:
\item{toxprob}{True toxicity probability.}
\item{effprob}{True efficacy probability.}
\item{phi}{Target toxicity probability.}
\item{delta}{Target efficacy probability.}
\item{lambda1}{Lower toxicity boundary in dose escalation/de-escalation.}
\item{lambda2}{Upper toxicity boundary in dose escalation/de-escalation.}
\item{eta1}{Lower efficacy boundary in dose escalation/de-escalation.}
\item{tau.T}{Toxicity assessment windows (days).}
\item{tau.E}{Efficacy assessment windows (days).}
\item{accrual}{Accrual rate (days) (average number of days necessary to
enroll one patient).}
\item{estpt.method}{Method to estimate the efficacy probability.}
\item{obd.method}{Method to select the optimal biological dose.}
\item{n.patient}{Average number of patients who were treated at each dose
level}
\item{prop.select}{Percentage of times that each dose level was selected as
optimal biological dose.}
\item{prop.stop}{Percentage of times that the study was terminated.}
\item{duration}{Expected study duration (days)}
}
\description{
Time-to-event Bayesian optimal interval design to accelerate dose-finding
based on both efficacy and toxicity outcomes (TITE-BOIN-ET design) is
implemented under a scenario
specified. Operating characteristics of the design are summarized by the
percentage of times that each dose level was selected as optimal biological
dose and the average number of patients who were treated at each dose level.
}
\details{
The \code{tite.boinet} is a function which generates the operating
characteristics of the time-to-event Bayesian optimal interval design to
accelerate dose-finding based on both efficacy and toxicity outcomes
(TITE-BOIN-ET design) by a simulation study. Users can specify a
variety of study settings to simulate studies, and choose methods to estimate
the efficacy probability and to select the optimal biological dose. The
operating characteristics of the design are summarized by the percentage of
times that each dose level was selected as optimal biological dose and the
average number of patients who were treated at each dose level. The
percentage of times that the study was terminated and the expected study
duration are also provided.
}
\examples{
n.dose      <- 6
start.dose  <- 1
size.cohort <- 3
n.cohort    <- 12

toxprob <- c(0.01,0.03,0.06,0.12,0.18,0.30)
effprob <- c(0.06,0.08,0.15,0.25,0.40,0.80)

phi   <- 0.33
delta <- 0.70

tau.T   <- 30
tau.E   <- 45
accrual <- 10

estpt.method <- "obs.prob"
obd.method   <- "max.effprob"

n.sim <- 10

tite.boinet(
  n.dose=n.dose, start.dose=start.dose,
  size.cohort=size.cohort, n.cohort=n.cohort,
  toxprob=toxprob, effprob=effprob,
  phi=phi, delta=delta,
  tau.T=tau.T, tau.E=tau.E, accrual=accrual,
  estpt.method=estpt.method, obd.method=obd.method,
  n.sim=n.sim)
}
\references{
Kentaro Takeda, Satoshi Morita and Masataka Taguri. TITE-BOIN-ET:
Time-to-event Bayesian optimal interval design to accelerate dose-finding
based on both efficacy and toxicity outcomes. \emph{Pharmaceutical Statistics}
2020; 19(3):335-349.

Yusuke Yamaguchi, Kentaro Takeda, Satoshi Yoshida and Kazushi Maruo.
Optimal biological dose selection in dose-finding trials with
model-assisted designs based on efficacy and toxicity: a simulation study.
\emph{Journal of Biopharmaceutical Statistics} 2023; doi: 10.1080/10543406.2023.2202259.
}
