% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/BN-methods.R, R/InferenceEngine-methods.R
\docType{methods}
\name{get.most.probable.values}
\alias{get.most.probable.values}
\alias{get.most.probable.values,BN}
\alias{get.most.probable.values,BN-method}
\alias{get.most.probable.values,InferenceEngine}
\alias{get.most.probable.values,InferenceEngine-method}
\title{compute the most probable values to be observed.}
\usage{
get.most.probable.values(x)

\S4method{get.most.probable.values}{BN}(x)

\S4method{get.most.probable.values}{InferenceEngine}(x)
}
\arguments{
\item{x}{a \code{\link{BN}} or \code{\link{InferenceEngine}} object.}
}
\value{
array containing, in each position, the most probable value for the corresponding variable.
}
\description{
Return an array containing the values that each variable of the network is more likely to take, according to the CPTS.
In case of ties take the first value.
}
\examples{
\dontrun{
# try with a BN object x
get.most.probable.values(x)

# now build an InferenceEngine object
eng <- InferenceEngine(x)
get.most.probable.values(eng)
}
}

