% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllClasses.R, R/InferenceEngine-methods.R
\docType{class}
\name{InferenceEngine-class}
\alias{InferenceEngine}
\alias{InferenceEngine,InferenceEngine-class}
\alias{InferenceEngine-class}
\alias{initialize,InferenceEngine-method}
\title{InferenceEngine class.}
\usage{
\S4method{initialize}{InferenceEngine}(.Object, ...)

InferenceEngine(bn = NULL, observations = NULL, ...)
}
\arguments{
\item{.Object}{an empty InferenceEngine object.}

\item{...}{potential further arguments of methods.}

\item{bn}{a \code{\link{BN}} object.}

\item{observations}{a list of observations composed by the two following vectors:
\itemize{
\item{\code{observed.vars}:}{vector of observed variables;}
\item{\code{observed.vals}:}{vector of values observed for the variables in \code{observed.vars} in the corresponding position.}
}}
}
\value{
an InferenceEngine object.

InferenceEngine object.
}
\description{
InferenceEngine class.

Constructor method of \code{\link{InferenceEngine}} class.

constructor for \code{\link{InferenceEngine}} object
}
\section{Slots}{

\describe{
  \item{\code{junction.tree}:}{junction tree adjacency matrix.}
  \item{\code{num.nodes}:}{number of nodes in the junction tree.}
  \item{\code{cliques}:}{list of cliques composing the nodes of the junction tree.}
  \item{\code{triangulated.graph}:}{adjacency matrix of the original triangulated graph.}
  \item{\code{jpts}:}{inferred joint probability tables.}
  \item{\code{bn}:}{original Bayesian Network (as object of class \code{\link{BN}}) as provided by the user, or learnt from a dataset.
         \code{NULL} if missing.}
  \item{\code{updated.bn}:}{Bayesian Network  (as object of class \code{\link{BN}}) as modified by a belief propagation computation. In particular,
         it will have different conditional probability tables with respect to its original version. \code{NULL} if missing.}
  \item{\code{observed.vars}:}{list of observed variables, by name or number.}
  \item{\code{observed.vals}:}{list of observed values for the corresponding variables in \code{observed.vars}.}
}
}
\examples{
\dontrun{
dataset <- BNDataset()
dataset <- read.dataset(dataset, "file.header", "file.data")
bn <- BN(dataset)
eng <- InferenceEngine(bn)

obs <- list(c("A","G,"X),c(1,2,1))
eng.2 <- InferenceEngine(bn, obs)
}
}

