% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_monitor.R
\name{global_monitor}
\alias{global_monitor}
\title{Global monitor}
\usage{
global_monitor(dag, df, alpha)
}
\arguments{
\item{dag}{an object of class \code{bn} from the \code{bnlearn} package}

\item{df}{a base R style dataframe}

\item{alpha}{single integer, usually the number of max levels in \code{df}}
}
\value{
A dataframe including the name of the vertices and the contribution of the vertices to the global monitor. It also returns a plot where vertices with higher contributions in absolute value are darker.
}
\description{
Contribution of each vertex of a Bayesian network to the global monitor
}
\details{
Consider a Bayesian network over variables \eqn{Y_1,\dots,Y_m} and suppose a dataset \eqn{(\boldsymbol{y}_1,\dots,\boldsymbol{y}_n)} has been observed, where \eqn{\boldsymbol{y}_i=(y_{i1},\dots,y_{im})} and \eqn{y_{ij}} is the i-th observation of the j-th variable. The global monitor is defined as the negative log-likelihood of the model, i.e.
\deqn{-\log(p(\boldsymbol{y}_1,\dots,\boldsymbol{y}_n))= - \sum_{j=1}^m\sum_{i=1}^n \log(p(y_{ij} | \pi_{ij})),}
where \eqn{\pi_{ij}} is the value of the parents of \eqn{Y_j} for the i-th observation. The contribution of the j-th vertex to the global monitor is thus
\deqn{-\sum_{i=1}^n\log(p(y_{ij}|\pi_{ij})).}
}
\examples{
global_monitor(chds_bn, chds, 3)

}
\references{
Cowell, R. G., Dawid, P., Lauritzen, S. L., & Spiegelhalter, D. J. (2006). Probabilistic networks and expert systems: Exact computational methods for Bayesian networks. Springer Science & Business Media.

Cowell, R. G., Verrall, R. J., & Yoon, Y. K. (2007). Modeling operational risk with Bayesian networks. Journal of Risk and Insurance, 74(4), 795-827.
}
\seealso{
\code{\link{influential_obs}}, \code{\link{node_monitor}}, \code{\link{seq_node_monitor}}, \code{\link{seq_pa_ch_monitor}}
}
