% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalization.R
\name{penUpdateInter}
\alias{penUpdateInter}
\title{Updating penalization matrix (between two omics types)}
\usage{
penUpdateInter(
  penmat,
  bnnames,
  type1,
  type2,
  intlist = NULL,
  pfbase = 2,
  intpf = 1,
  intsame = 1,
  bi = FALSE
)
}
\arguments{
\item{penmat}{a square penalization matrix; to initialize use \link{penInit}}

\item{bnnames}{object of class bnInfo; see \link{bnInfo}}

\item{type1}{name of omics type (from)}

\item{type2}{name of omics type (to)}

\item{intlist}{(optional) a matrix or data frame containing a list of interactions and optionally their scores; 2 columns are necessary 'gene1' and 'gene2'}

\item{pfbase}{a numeric value more or equal to 1, base penalization factor; 2 by default (1 corresponds to no penalization)}

\item{intpf}{(optional) a numeric value more or equal to 1, this value will be used to penalize interactions from 'intlist'}

\item{intsame}{penalization factor for edges connecting the same genes}

\item{bi}{(logical) indicates if interactions should be considered bi-directed}
}
\value{
returns a square matrix containing edge specific penalization factors
}
\description{
This function can be used to update an existing penalization matrix
}
\author{
Polina Suter
}
