% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMSC-plot.R
\name{plot.pairwise.BMSC}
\alias{plot.pairwise.BMSC}
\title{Plot estimates from a \code{pairwise.BMSC} object.}
\usage{
\method{plot}{pairwise.BMSC}(x, type = "interval", CI = 0.95, ...)
}
\arguments{
\item{x}{An object of class \link{pairwise.BMSC}.}

\item{type}{a parameter to select the typology of graph
\describe{
        \item{interval}{the estimates will be represented by means of pointrange, with median and the boundaries of the credible interval}
        \item{area}{a density plot}
        \item{hist}{a density histogram}
}}

\item{CI}{the dimension of the Credible Interval (or Equally Tailed Interval). Default 0.95.}

\item{...}{other arguments are ignored.}
}
\value{
a list of two ggplot2 objects
}
\description{
Plot estimates from a \code{pairwise.BMSC} object.
}
\examples{
 \donttest{

######################################
# simulation of controls' group data
######################################

# Number of levels for each condition and trials
NCond1  <- 2
NCond2  <- 2
Ntrials <- 8
NSubjs  <- 30

betas <- c( 0 , 0 , 0 ,  0.2)

data.sim <- expand.grid(
  trial      = 1:Ntrials,
  ID         = factor(1:NSubjs),
  Cond1      = factor(1:NCond1),
  Cond2      = factor(1:NCond2)
)

contrasts(data.sim$Cond1) <- contr.sum(2)
contrasts(data.sim$Cond2) <- contr.sum(2)

### d.v. generation
y <- rep( times = nrow(data.sim) , NA )

# cheap simulation of individual random intercepts
set.seed(1)
rsubj <- rnorm(NSubjs , sd = 0.1)

for( i in 1:length( levels( data.sim$ID ) ) ){

  sel <- which( data.sim$ID == as.character(i) )

  mm  <- model.matrix(~ Cond1 * Cond2 , data = data.sim[ sel , ] )

  set.seed(1 + i)
  y[sel] <- mm \%*\% as.matrix(betas + rsubj[i]) +
    rnorm( n = Ntrials * NCond1 * NCond2 )

}

data.sim$y <- y

# just checking the simulated data...
boxplot(y~Cond1*Cond2, data = data.sim)

######################################
# simulation of patient data
######################################

betas.pt <- c( 0 , 0.8 , 0 ,  0)

data.pt <- expand.grid(
  trial      = 1:Ntrials,
  Cond1      = factor(1:NCond1),
  Cond2      = factor(1:NCond2)
)

contrasts(data.pt$Cond1) <- contr.sum(2)
contrasts(data.pt$Cond2) <- contr.sum(2)

### d.v. generation
mm  <- model.matrix(~ Cond1 * Cond2 , data = data.pt )

set.seed(5)
data.pt$y <- (mm \%*\% as.matrix(betas.pt) +
                rnorm( n = Ntrials * NCond1 * NCond2 ))[,1]

# just checking the simulated data...
boxplot(y~Cond1*Cond2, data = data.pt)

mdl <- BMSC(y ~ Cond1 * Cond2 + ( 1 | ID ),
            data_ctrl = data.sim, data_sc = data.pt, seed = 77,
            typeprior = "cauchy", s = 1)

summary(mdl)

pp_check(mdl)

# compute pairwise contrasts
ph <- pairwise.BMSC( mdl, contrast = "Cond11:Cond21")

ph

# plot pairwise comparisons

plot(ph)

plot(ph , type = "area")

# customization of pairiwse comparisons plot

plot(ph)[[1]]+theme_bw(base_size = 18)

plot(ph , type = "area")[[1]]+theme_bw(base_size = 18)+
   theme(strip.text.y = element_text( angle = 0))
}

}
