test_that("mcount behaves as expected",{
  expect_error(object = mcount("a"), "'M' must be an object of class 'matrix'")
  expect_error(object = mcount(matrix("a",3,3)), "Elements of 'M' must be numeric")
  expect_error(object = mcount(matrix(-1,3,3)), "Elements of 'M' must be greater than or equal to zero")
  expect_error(object = mcount(matrix(1,3,3), six_node = TRUE, normalise = 7), "'normalise' must be of class 'logical' i.e. TRUE or FALSE")
  expect_error(object = mcount(matrix(1,3,3), six_node = 7, normalise = TRUE), "'six_node' must be of class 'logical' i.e. TRUE or FALSE")

  expect_equal(object = mcount(M = mat, six_node = FALSE, normalise = FALSE), mcount_SF_NF)
  expect_equal(object = mcount(M = mat, six_node = TRUE, normalise = FALSE), mcount_ST_NF)
  expect_equal(object = mcount(M = mat, six_node = FALSE, normalise = TRUE), mcount_SF_NT)
  expect_equal(object = mcount(M = mat, six_node = TRUE, normalise = TRUE), mcount_ST_NT)
  expect_equal(mcount(M = t(mat), six_node = TRUE, normalise = TRUE), mcount_transpose_ST_NT)
  expect_equal(mcount(M = t(mat), six_node = FALSE, normalise = TRUE), mcount_transpose_SF_NT)
  expect_equal(mcount(M = t(mat), six_node = TRUE, normalise = FALSE), mcount_transpose_ST_NF)
  expect_equal(mcount(M = t(mat), six_node = FALSE, normalise = FALSE), mcount_transpose_SF_NF)
})
