% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/positions.R
\name{positions}
\alias{positions}
\title{Calculate node position vectors}
\usage{
positions(M, six_node, level = "all", normalisation = "none")
}
\arguments{
\item{M}{A numeric matrix representing interactions between two groups of nodes. Each row corresponds to a node in one level
and each column corresponds to a node in the other level. Elements of M are positive numbers if nodes do interact, and 0
otherwise. Formally, M is an incidence matrix. When nodes i and j interact, m_ij > 0; if they do not interact, m_ij = 0.
If interactions are weighted (non-zero matrix elements take values greater than 1), the function will automatically convert the matrix to a binary
matrix.}

\item{six_node}{Logical; should six node motifs be counted?}

\item{level}{Which node level should positions be calculated for: "rows", "columns" or "all"?  Defaults to "all".}

\item{normalisation}{Which normalisation should be used: "none", "sum" or "size class"?  Defaults to "none".}
}
\value{
Returns a data frame with one column for each motif position: 46 columns if \code{six_node} is FALSE, and 148 columns if \code{six_node} is TRUE.
Columns names are given as "px" where x is the ID of the position as described in Simmons et al. (2017) (and originally in Appendix 1 of Baker et al. (2015))

For a network with A rows and P columns, by default (where \code{level} = "all") the data frame has A + P rows, one for each node. If \code{level} = "rows", the data frame will have A rows, one for each row node;
if \code{level} = "columns", it will have P rows, one for each column node.

By default, the elements of this data frame will be the raw position counts. If \code{normalisation} is set to "sum" or "size class", the elements will be
normalised position counts as described above.
}
\description{
Counts the frequency with which nodes occur in different positions within motifs.
}
\details{
Counts the number of times each node in a network occurs in each of the 46 (if \code{six_node} = FALSE) or 148 (if \code{six_node} = TRUE) unique positions within motifs (to quantify a node's structural role).

The \code{level} argument controls which node group positions are calculated for: "rows" returns position counts for all nodes in rows, "columns"
returns counts for all nodes in columns, and "all" return counts for all nodes in the network.

Nodes with more interactions will tend to appear in more positions. Normalisation helps control for this effect.
"none" performs no normalisation and will return the raw position counts.
"sum" divides position counts for each node by the total number of times that node appears in any position.
"size class" divides position counts for each node by the total number of times that node appears in any position within the same motif size class.

Warning: including six node motifs is fine for most networks. However, for large networks, counting six node motifs can be slow and memory intensive. In some cases, R can crash if there is not enough memory.
}
\examples{
set.seed(123)
row <- 15
col <- 15
m <- matrix(sample(0:1, row*col, replace=TRUE), row, col)
rownames(m) <- paste0("R", 1:nrow(m)) # give the matrix row names
colnames(m) <- paste0("C", 1:ncol(m)) # give the matrix column names
positions(M = m, six_node = TRUE, level = "all", normalisation = "none")
}
\references{
Baker, N., Kaartinen, R., Roslin, T., and Stouffer, D. B. (2015). Species’ roles in food webs show fidelity across a highly variable oak forest. Ecography, 38(2):130–139.

Simmons, B I., Sweering, M. J. M., Dicks, L. V., Sutherland, W. J. and Di Clemente, R. bmotif: a package for counting motifs in bipartite networks
}
