% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bls_api.R
\name{bls_api}
\alias{bls_api}
\title{Basic Request Mechanism for BLS Tables}
\usage{
bls_api(seriesid, startyear = NULL, endyear = NULL,
  registrationKey = NULL, catalog = FALSE, calculations = FALSE,
  annualaverage = FALSE, ...)
}
\arguments{
\item{seriesid}{The BLS id of the series your trying to load. A common format would be 'LAUCN040010000000005'. 
WARNING: All seriesIDs must contain the same time resolution. For example, monthly data sets can not be combined with annual or semi-annual data.
If you need help finding seriesIDs, check the BLS website or the BLS Data Finder--links below.}

\item{startyear}{The first year in your data set.}

\item{endyear}{The last year in your data set.}

\item{registrationKey}{The API key issued to you from the BLS website.}

\item{catalog}{Series description information available only for certain data sets.}

\item{calculations}{Returns year-over-year calculations if set to TRUE.}

\item{annualaverage}{Returns an annual average if set to TRUE.}

\item{...}{additional arguments}
}
\description{
Return data frame from one or more requests via the US Bureau of Labor Statistics API. Provided arguments are in the form of BLS series ids.
}
\examples{


## API Version 1.0 R Script Sample Code
## Single Series request
df <- bls_api("LAUCN040010000000005")

\dontrun{
## API Version 1.0 R Script Sample Code
## Multiple Series request with date params.
df <- bls_api(c("LAUCN040010000000005", "LAUCN040010000000006"), 
startyear = "2010", endyear = "2012")


## API Version 1.0 R Script Sample Code
## Multiple Series request with date params.
df <- bls_api(c("LAUCN040010000000005", "LAUCN040010000000006"), 
startyear = "2010", endyear = "2012")


## API Version 2.0 R Script Sample Code
## Multiple Series request with full params allowed by v2.
df <- bls_api(c("LAUCN040010000000005", "LAUCN040010000000006"),
startyear = "2010", endyear = "2012",
registrationKey = "BLS_KEY", 
calculations = TRUE, annualaverage = TRUE, catalog = TRUE)
}

}
\seealso{
\url{https://www.bls.gov/data/}

\url{https://beta.bls.gov/dataQuery/search}
}
\keyword{api}
\keyword{bls}
\keyword{cpi}
\keyword{economics}
\keyword{inflation}
\keyword{unemployment}
