% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-backward-elimination.R
\name{blr_step_aic_backward}
\alias{blr_step_aic_backward}
\alias{blr_step_aic_backward.default}
\alias{plot.blr_step_aic_backward}
\title{Stepwise AIC backward elimination}
\usage{
blr_step_aic_backward(model, details = FALSE, ...)

\method{blr_step_aic_backward}{default}(model, details = FALSE, ...)

\method{plot}{blr_step_aic_backward}(x, text_size = 3, ...)
}
\arguments{
\item{model}{An object of class \code{glm}; the model should include all
candidate predictor variables.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{...}{Other arguments.}

\item{x}{An object of class \code{blr_step_aic_backward}.}

\item{text_size}{size of the text in the plot.}
}
\value{
\code{blr_step_aic_backward} returns an object of class
\code{"blr_step_aic_backward"}. An object of class
\code{"blr_step_aic_backward"} is a list containing the following components:

\item{model}{model with the least AIC; an object of class \code{glm}}
\item{candidates}{candidate predictor variables}
\item{steps}{total number of steps}
\item{predictors}{variables removed from the model}
\item{aics}{akaike information criteria}
\item{bics}{bayesian information criteria}
\item{devs}{deviances}
}
\description{
Build regression model from a set of candidate predictor variables by
removing predictors based on akaike information criterion, in a stepwise
manner until there is no variable left to remove any more.
}
\examples{
\dontrun{
model <- glm(honcomp ~ female + read + science + math + prog + socst,
data = hsb2, family = binomial(link = 'logit'))

# elimination summary
blr_step_aic_backward(model)

# print details of each step
blr_step_aic_backward(model, details = TRUE)

# plot
plot(blr_step_aic_backward(model))

# final model
k <- blr_step_aic_backward(model)
k$model

}

}
\references{
Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}
\seealso{
Other variable selection procedures: \code{\link{blr_step_aic_both}},
  \code{\link{blr_step_aic_forward}},
  \code{\link{blr_step_p_backward}},
  \code{\link{blr_step_p_forward}}
}
\concept{variable selection procedures}
